/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.mantle.effect;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.auxiliary.charge.AlignmentChargeHandler;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.constellation.mantle.MantleEffect;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.armor.ItemMantle;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ConstellationsAS;
import hellfirepvp.astralsorcery.common.util.collision.CustomCollisionHandler;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.LogicalSide;

public class MantleEffectAevitas
extends MantleEffect {
    public static AevitasConfig CONFIG = new AevitasConfig();

    public MantleEffectAevitas() {
        super(ConstellationsAS.aevitas);
    }

    @Override
    protected boolean usesTickMethods() {
        return true;
    }

    @Override
    protected void tickServer(PlayerEntity player) {
        FoodStats stats;
        super.tickServer(player);
        if (MantleEffectAevitas.isStandingOnAir((Entity)player)) {
            AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Double)MantleEffectAevitas.CONFIG.chargeCostPerTravelTick.get()).floatValue(), false);
        }
        int healChance = (Integer)MantleEffectAevitas.CONFIG.healChance.get();
        int foodChance = (Integer)MantleEffectAevitas.CONFIG.feedChance.get();
        if (healChance > 0 && rand.nextInt(healChance) == 0) {
            player.func_70691_i(((Double)MantleEffectAevitas.CONFIG.healthPerCycle.get()).floatValue());
        }
        if (foodChance > 0 && rand.nextInt(foodChance) == 0 && ((stats = player.func_71024_bL()).func_75116_a() < 20 || stats.func_75115_e() < 5.0f) && AlignmentChargeHandler.INSTANCE.hasCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerFood.get()).intValue())) {
            stats.func_75122_a(((Double)MantleEffectAevitas.CONFIG.foodPerCycle.get()).intValue(), 0.5f);
            AlignmentChargeHandler.INSTANCE.drainCharge(player, LogicalSide.SERVER, ((Integer)MantleEffectAevitas.CONFIG.chargeCostPerFood.get()).intValue(), false);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient(PlayerEntity player) {
        super.tickClient(player);
        this.playCapeSparkles(player, 0.1f);
        if (MantleEffectAevitas.isStandingOnAir((Entity)player)) {
            Vector3 center = Vector3.atEntityCorner((Entity)player).addY(0.15f);
            for (int i = 0; i < 5; ++i) {
                Vector3 offset = Vector3.random().setY(0).normalize().multiply(rand.nextFloat() * 5.0f).addY(rand.nextFloat() * -0.4f).add(center);
                FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setScaleMultiplier(0.25f + rand.nextFloat() * 0.15f)).alpha(VFXAlphaFunction.PYRAMID)).setMotion(Vector3.random().normalize().multiply(0.004f))).setMaxAge(45 + rand.nextInt(20));
                if (rand.nextInt(3) == 0) {
                    p.color(VFXColorFunction.WHITE);
                    continue;
                }
                p.color(VFXColorFunction.constant(ColorsAS.RITUAL_CONSTELLATION_AEVITAS));
            }
        }
    }

    @Override
    public MantleEffect.Config getConfig() {
        return CONFIG;
    }

    public static boolean canSupportEffect(PlayerEntity player) {
        LogicalSide side = player.func_130014_f_().func_201670_d() ? LogicalSide.CLIENT : LogicalSide.SERVER;
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        return progress.doPerkAbilities() && progress.hasConstellationDiscovered(ConstellationsAS.aevitas) && AlignmentChargeHandler.INSTANCE.hasCharge(player, side, ((Double)MantleEffectAevitas.CONFIG.chargeCostPerTravelTick.get()).floatValue());
    }

    public static boolean isStandingOnAir(Entity entity) {
        if (entity.func_233570_aj_()) {
            World world = entity.func_130014_f_();
            BlockPos at = entity.func_233580_cy_().func_177977_b();
            return world.func_180495_p(at).isAir((IBlockReader)world, at);
        }
        return false;
    }

    public static class PlayerWalkableAir
    implements CustomCollisionHandler {
        private static final AxisAlignedBB FULL_BOX = new AxisAlignedBB(BlockPos.field_177992_a);

        @Override
        public boolean shouldAddCollisionFor(Entity entity) {
            if (!(entity instanceof PlayerEntity) || ((PlayerEntity)entity).field_71075_bZ.field_75100_b) {
                return false;
            }
            return ItemMantle.getEffect((LivingEntity)entity, (IWeakConstellation)ConstellationsAS.aevitas) != null && MantleEffectAevitas.canSupportEffect((PlayerEntity)entity);
        }

        @Override
        public void addCollision(Entity entity, AxisAlignedBB testBox, List<AxisAlignedBB> additionalCollision) {
            int yOffset = 1;
            if (entity.func_213283_Z() == Pose.CROUCHING && MantleEffectAevitas.isStandingOnAir(entity)) {
                yOffset = 2;
            }
            additionalCollision.add(FULL_BOX.func_72317_d(entity.func_226277_ct_(), Math.floor(entity.func_226278_cu_()) - (double)yOffset, entity.func_226281_cx_()));
        }
    }

    public static class AevitasConfig
    extends MantleEffect.Config {
        private final int defaultHealChance = 80;
        private final int defaultFeedChance = 80;
        private final double defaultHealthPerCycle = 0.5;
        private final double defaultFoodPerCycle = 1.0;
        private final double defaultChargeCostPerTravelTick = 2.5;
        private final int defaultChargeCostPerHeal = 100;
        private final int defaultChargeCostPerFood = 100;
        public ForgeConfigSpec.IntValue healChance;
        public ForgeConfigSpec.IntValue feedChance;
        public ForgeConfigSpec.DoubleValue healthPerCycle;
        public ForgeConfigSpec.DoubleValue foodPerCycle;
        public ForgeConfigSpec.DoubleValue chargeCostPerTravelTick;
        public ForgeConfigSpec.IntValue chargeCostPerHeal;
        public ForgeConfigSpec.IntValue chargeCostPerFood;

        public AevitasConfig() {
            super("aevitas");
        }

        @Override
        public void createEntries(ForgeConfigSpec.Builder cfgBuilder) {
            super.createEntries(cfgBuilder);
            ForgeConfigSpec.Builder builder = cfgBuilder.comment("Set the chance of '1 in <this value>' per tick to do 1 heal cycle. Amount healed per cycle is determined by 'healthPerCycle' config option. Set to 0 to disable.").translation(this.translationKey("healChance"));
            this.getClass();
            this.healChance = builder.defineInRange("healChance", 80, 0, Integer.MAX_VALUE);
            ForgeConfigSpec.Builder builder2 = cfgBuilder.comment("Set the chance of '1 in <this value>' per tick to do 1 food cycle. Amount fed per cycle is determined by 'foodPerCycle' config option. Set to 0 to disable.").translation(this.translationKey("feedChance"));
            this.getClass();
            this.feedChance = builder2.defineInRange("feedChance", 80, 0, Integer.MAX_VALUE);
            this.healthPerCycle = cfgBuilder.comment("Set the amount of health recovered by health cycle.").translation(this.translationKey("healthPerCycle")).defineInRange("healthPerCycle", this.defaultHealthPerCycle, 0.0, 100.0);
            this.foodPerCycle = cfgBuilder.comment("Set the amount of food recovered by food cycle.").translation(this.translationKey("foodPerCycle")).defineInRange("foodPerCycle", this.defaultFoodPerCycle, 0.0, 100.0);
            this.chargeCostPerTravelTick = cfgBuilder.comment("Set the amount alignment charge consumed per tick when walking/standing in the air").translation(this.translationKey("chargeCostPerTravelTick")).defineInRange("chargeCostPerTravelTick", this.defaultChargeCostPerTravelTick, 0.0, 100.0);
            ForgeConfigSpec.Builder builder3 = cfgBuilder.comment("Set the amount alignment charge consumed per feed-cycle").translation(this.translationKey("chargeCostPerFood"));
            this.getClass();
            this.chargeCostPerFood = builder3.defineInRange("chargeCostPerFood", 100, 0, 1000);
            ForgeConfigSpec.Builder builder4 = cfgBuilder.comment("Set the amount alignment charge consumed per heal-cycle").translation(this.translationKey("chargeCostPerHeal"));
            this.getClass();
            this.chargeCostPerHeal = builder4.defineInRange("chargeCostPerHeal", 100, 0, 1000);
        }
    }
}

