/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.builder;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.block.tile.altar.AltarType;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeBuilder;
import hellfirepvp.astralsorcery.common.crafting.helper.CustomRecipeSerializer;
import hellfirepvp.astralsorcery.common.crafting.recipe.SimpleAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeGrid;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.AltarRecipeTypeHandler;
import hellfirepvp.astralsorcery.common.crafting.recipe.altar.effect.AltarRecipeEffect;
import hellfirepvp.astralsorcery.common.lib.RecipeSerializersAS;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class SimpleAltarRecipeBuilder<T extends SimpleAltarRecipe>
extends CustomRecipeBuilder<T> {
    private final T recipe;

    private SimpleAltarRecipeBuilder(T recipe) {
        this.recipe = recipe;
    }

    public static TypedRecipeBuilder<SimpleAltarRecipe> builder() {
        return new TypedRecipeBuilder<SimpleAltarRecipe>(null);
    }

    public static <T extends SimpleAltarRecipe> TypedRecipeBuilder<T> ofType(AltarRecipeTypeHandler.Type<T> type) {
        return new TypedRecipeBuilder(type);
    }

    public SimpleAltarRecipeBuilder<T> setInputs(AltarRecipeGrid.Builder gridBuilder) {
        ((SimpleAltarRecipe)this.recipe).setInputs(gridBuilder.build());
        return this;
    }

    public SimpleAltarRecipeBuilder<T> setFocusConstellation(IConstellation focusConstellation) {
        ((SimpleAltarRecipe)this.recipe).setFocusConstellation(focusConstellation);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> addRelayInput(ITag.INamedTag<Item> tag) {
        return this.addRelayInput(Ingredient.func_199805_a(tag));
    }

    public SimpleAltarRecipeBuilder<T> addRelayInput(IItemProvider item) {
        return this.addRelayInput(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}));
    }

    public SimpleAltarRecipeBuilder<T> addRelayInput(Ingredient ingredient) {
        ((SimpleAltarRecipe)this.recipe).addRelayInput(ingredient);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> addAltarEffect(AltarRecipeEffect effect) {
        ((SimpleAltarRecipe)this.recipe).addAltarEffect(effect);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> setStarlightRequirement(float percentOfAltarBar) {
        ((SimpleAltarRecipe)this.recipe).setStarlightRequirement((int)((float)((SimpleAltarRecipe)this.recipe).getAltarType().getStarlightCapacity() * MathHelper.func_76131_a((float)percentOfAltarBar, (float)0.0f, (float)1.0f)));
        return this;
    }

    public SimpleAltarRecipeBuilder<T> setStarlightRequirement(int requiredStarlight) {
        ((SimpleAltarRecipe)this.recipe).setStarlightRequirement(requiredStarlight);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> multiplyDuration(float duration) {
        ((SimpleAltarRecipe)this.recipe).setDuration((int)((float)((SimpleAltarRecipe)this.recipe).getAltarType().getDefaultAltarCraftingDuration() * duration));
        return this;
    }

    public SimpleAltarRecipeBuilder<T> setDuration(int duration) {
        ((SimpleAltarRecipe)this.recipe).setDuration(duration);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> addOutput(IItemProvider output) {
        this.addOutput(new ItemStack(output));
        return this;
    }

    public SimpleAltarRecipeBuilder<T> addOutput(ItemStack output) {
        ((SimpleAltarRecipe)this.recipe).addOutput(output);
        return this;
    }

    public SimpleAltarRecipeBuilder<T> modify(Consumer<T> recipeFn) {
        recipeFn.accept(this.recipe);
        return this;
    }

    @Override
    @Nonnull
    protected T validateAndGet() {
        AltarType type = ((SimpleAltarRecipe)this.recipe).getAltarType();
        ((SimpleAltarRecipe)this.recipe).getInputs().validate(type);
        if (!type.isThisGEThan(AltarType.RADIANCE)) {
            if (((SimpleAltarRecipe)this.recipe).getRelayInputs().size() > 0) {
                throw new IllegalArgumentException("Cannot make a altar recipe require relay inputs, if the recipe isn't for a T4 altar or higher.");
            }
            if (((SimpleAltarRecipe)this.recipe).getFocusConstellation() != null) {
                throw new IllegalArgumentException("Cannot make a altar recipe require a constellation focus, if the recipe isn't for a T4 altar or higher.");
            }
        }
        if (((SimpleAltarRecipe)this.recipe).getDuration() <= 0) {
            throw new IllegalArgumentException("Cannot make a altar recipe with 0 or less ticks duration!");
        }
        if (((SimpleAltarRecipe)this.recipe).getStarlightRequirement() > type.getStarlightCapacity()) {
            throw new IllegalArgumentException("Cannot make a recipe require more starlight than the capacity of the corresponding altar allows for.");
        }
        return this.recipe;
    }

    @Override
    protected CustomRecipeSerializer<T> getSerializer() {
        return RecipeSerializersAS.ALTAR_RECIPE_SERIALIZER;
    }

    /* synthetic */ SimpleAltarRecipeBuilder(SimpleAltarRecipe x0, 1 x1) {
        this(x0);
    }

    public static class TypedRecipeBuilder<T extends SimpleAltarRecipe> {
        @Nullable
        private final AltarRecipeTypeHandler.Type<T> type;

        private TypedRecipeBuilder(@Nullable AltarRecipeTypeHandler.Type<T> type) {
            this.type = type;
        }

        public SimpleAltarRecipeBuilder<T> createRecipe(ForgeRegistryEntry<?> nameProvider, AltarType altarType) {
            return this.createRecipe(AstralSorcery.key(nameProvider.getRegistryName().func_110623_a()), altarType);
        }

        public SimpleAltarRecipeBuilder<T> createRecipe(ResourceLocation recipeId, AltarType altarType) {
            SimpleAltarRecipe converted;
            SimpleAltarRecipe recipe = new SimpleAltarRecipe(recipeId, altarType);
            if (this.type == null) {
                converted = AltarRecipeTypeHandler.DEFAULT.convert(recipe);
            } else {
                converted = this.type.convert(recipe);
                converted.setCustomRecipeType(this.type.getKey());
            }
            return new SimpleAltarRecipeBuilder(converted, null);
        }
    }
}

