/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.util.ServerLifecycleListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;

public class ResearchIOThread
implements ServerLifecycleListener {
    private static final ResearchIOThread instance = new ResearchIOThread();
    private static Timer timer;
    private static TimerTask saveTask;
    private final Map<UUID, PlayerProgress> playerSaveQueue = Maps.newHashMap();
    private final Map<UUID, PlayerProgress> awaitingSaveQueue = Maps.newHashMap();
    private boolean inSave = false;
    private boolean skipTick = false;

    private ResearchIOThread() {
    }

    public static ResearchIOThread getInstance() {
        return instance;
    }

    @Override
    public void onServerStart() {
        this.reset();
        saveTask = new TimerTask(){

            @Override
            public void run() {
                instance.doSave();
            }
        };
        timer = new Timer("ResearchIOThread", true);
        timer.scheduleAtFixedRate(saveTask, 30000L, 30000L);
    }

    @Override
    public void onServerStop() {
        this.flushAndSaveAll();
        this.reset();
    }

    private void reset() {
        if (saveTask != null) {
            saveTask.cancel();
            saveTask = null;
        }
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
    }

    public void doSave() {
        if (this.skipTick) {
            return;
        }
        this.inSave = true;
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerSaveQueue.entrySet()) {
            ResearchIOThread.saveNow(entry.getKey(), entry.getValue());
        }
        this.playerSaveQueue.clear();
        this.inSave = false;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        this.awaitingSaveQueue.clear();
    }

    private void scheduleSave(UUID playerUUID, PlayerProgress copiedProgress) {
        if (this.inSave) {
            this.awaitingSaveQueue.put(playerUUID, copiedProgress);
        } else {
            this.playerSaveQueue.put(playerUUID, copiedProgress);
        }
    }

    private void cancelScheduledSave(UUID playerUUID) {
        this.awaitingSaveQueue.remove(playerUUID);
        this.playerSaveQueue.remove(playerUUID);
    }

    private void flushAndSaveAll() {
        this.skipTick = true;
        this.playerSaveQueue.putAll(this.awaitingSaveQueue);
        for (Map.Entry<UUID, PlayerProgress> entry : this.playerSaveQueue.entrySet()) {
            ResearchIOThread.saveNow(entry.getKey(), entry.getValue());
        }
        this.playerSaveQueue.clear();
        this.awaitingSaveQueue.clear();
        this.skipTick = false;
        this.inSave = false;
    }

    public static void saveProgress(UUID playerUUID, PlayerProgress copiedProgress) {
        if (instance != null) {
            instance.scheduleSave(playerUUID, copiedProgress);
        }
    }

    public static void cancelSave(UUID playerUUID) {
        if (instance != null) {
            instance.cancelScheduledSave(playerUUID);
        }
    }

    static void saveNow(UUID playerUUID, PlayerProgress progress) {
        File playerFile = ResearchHelper.getPlayerFile(playerUUID);
        try {
            Files.copy((File)playerFile, (File)ResearchHelper.getPlayerBackupFile(playerUUID));
        }
        catch (IOException exc) {
            AstralSorcery.log.warn("Failed copying progress file contents to backup file!");
            exc.printStackTrace();
        }
        try {
            CompoundNBT cmp = new CompoundNBT();
            progress.store(cmp);
            CompressedStreamTools.func_74795_b((CompoundNBT)cmp, (File)playerFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

