/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integration.jei;

import java.util.Arrays;
import java.util.List;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;

public abstract class JEICategory<T extends IRecipe<?>>
implements IRecipeCategory<T> {
    private final String locTitle;
    private final ResourceLocation uid;

    public JEICategory(ResourceLocation categoryId) {
        this(JEICategory.category(categoryId), categoryId);
    }

    public JEICategory(String unlocTitle, ResourceLocation uid) {
        this.locTitle = I18n.func_135052_a((String)unlocTitle, (Object[])new Object[0]);
        this.uid = uid;
    }

    protected static String category(ResourceLocation categoryId) {
        return String.format("jei.category.%s.%s", categoryId.func_110624_b(), categoryId.func_110623_a());
    }

    protected static List<ItemStack> ingredientStacks(Ingredient ingredient) {
        return Arrays.asList(ingredient.func_193365_a());
    }

    protected static void initFluidInput(IGuiFluidStackGroup group, int index, int x, int y) {
        group.init(index, true, x + 1, y + 1, 16, 16, 1000, false, null);
    }

    protected static void initFluidOutput(IGuiFluidStackGroup group, int index, int x, int y) {
        group.init(index, false, x + 1, y + 1, 16, 16, 1000, false, null);
    }

    public abstract List<T> getRecipes();

    public ResourceLocation getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.locTitle;
    }
}

