/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.crystal;

import hellfirepvp.astralsorcery.common.constellation.ConstellationItem;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.crystal.CrystalAttributes;
import hellfirepvp.astralsorcery.common.data.research.GatedKnowledge;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.item.base.IConstellationFocus;
import hellfirepvp.astralsorcery.common.item.crystal.ItemCrystalBase;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ItemAttunedCrystalBase
extends ItemCrystalBase
implements IConstellationFocus,
ConstellationItem {
    public ItemAttunedCrystalBase(Item.Properties prop) {
        super(prop);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> toolTip, ITooltipFlag flag) {
        CrystalAttributes.TooltipResult result = this.addCrystalPropertyToolTip(stack, toolTip);
        if (result != null) {
            IMinorConstellation tr;
            ProgressionTier tier = ResearchHelper.getClientProgress().getTierReached();
            boolean addedMissing = result != CrystalAttributes.TooltipResult.ADDED_ALL;
            IWeakConstellation c = this.getAttunedConstellation(stack);
            if (c != null) {
                if (GatedKnowledge.CRYSTAL_TUNE.canSee(tier) && ResearchHelper.getClientProgress().hasConstellationDiscovered(c)) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("crystal.info.astralsorcery.attuned", new Object[]{c.getConstellationName().func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                } else if (!addedMissing) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.progress.missing.knowledge").func_240699_a_(TextFormatting.GRAY));
                    addedMissing = true;
                }
            }
            if ((tr = this.getTraitConstellation(stack)) != null) {
                if (GatedKnowledge.CRYSTAL_TUNE.canSee(tier) && ResearchHelper.getClientProgress().hasConstellationDiscovered(tr)) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("crystal.info.astralsorcery.trait", new Object[]{tr.getConstellationName().func_240699_a_(TextFormatting.BLUE)}).func_240699_a_(TextFormatting.GRAY));
                } else if (!addedMissing) {
                    toolTip.add((ITextComponent)new TranslationTextComponent("astralsorcery.progress.missing.knowledge").func_240699_a_(TextFormatting.GRAY));
                }
            }
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IWeakConstellation cst = this.getAttunedConstellation(stack);
        if (cst != null) {
            return new TranslationTextComponent(super.func_77667_c(stack) + ".typed", new Object[]{cst.getConstellationName()});
        }
        return super.func_200295_i(stack);
    }

    @Override
    @Nullable
    public IConstellation getFocusConstellation(ItemStack stack) {
        return this.getAttunedConstellation(stack);
    }

    @Override
    @Nullable
    public IWeakConstellation getAttunedConstellation(ItemStack stack) {
        return (IWeakConstellation)IConstellation.readFromNBT(NBTHelper.getPersistentData(stack));
    }

    @Override
    public boolean setAttunedConstellation(ItemStack stack, @Nullable IWeakConstellation cst) {
        if (cst != null) {
            cst.writeToNBT(NBTHelper.getPersistentData(stack));
        } else {
            NBTHelper.getPersistentData(stack).func_82580_o(IConstellation.getDefaultSaveKey());
        }
        return true;
    }

    @Override
    @Nullable
    public IMinorConstellation getTraitConstellation(ItemStack stack) {
        return (IMinorConstellation)IConstellation.readFromNBT(NBTHelper.getPersistentData(stack), "constellationTrait");
    }

    @Override
    public boolean setTraitConstellation(ItemStack stack, @Nullable IMinorConstellation cst) {
        if (cst != null) {
            cst.writeToNBT(NBTHelper.getPersistentData(stack), "constellationTrait");
        } else {
            NBTHelper.getPersistentData(stack).func_82580_o("constellationTrait");
        }
        return true;
    }
}

