/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.play.client;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.network.base.ASPacket;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.LogicalSide;

public class PktDiscoverConstellation
extends ASPacket<PktDiscoverConstellation> {
    private IConstellation constellation;

    public PktDiscoverConstellation() {
    }

    public PktDiscoverConstellation(IConstellation constellation) {
        this.constellation = constellation;
    }

    @Override
    @Nonnull
    public ASPacket.Encoder<PktDiscoverConstellation> encoder() {
        return (packet, buffer) -> ByteBufUtils.writeRegistryEntry(buffer, packet.constellation);
    }

    @Override
    @Nonnull
    public ASPacket.Decoder<PktDiscoverConstellation> decoder() {
        return buffer -> new PktDiscoverConstellation((IConstellation)ByteBufUtils.readRegistryEntry(buffer));
    }

    @Override
    @Nonnull
    public ASPacket.Handler<PktDiscoverConstellation> handler() {
        return (packet, context, side) -> context.enqueueWork(() -> {
            ServerPlayerEntity player;
            PlayerProgress prog;
            if (side == LogicalSide.SERVER && (prog = ResearchHelper.getProgress((PlayerEntity)(player = context.getSender()), LogicalSide.SERVER)).isValid() && packet.constellation.canDiscover((PlayerEntity)player, prog) && ResearchManager.discoverConstellation(packet.constellation, (PlayerEntity)player)) {
                ResearchHelper.sendConstellationDiscoveryMessage((ICommandSource)player, packet.constellation);
            }
        });
    }
}

