/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk;

import hellfirepvp.astralsorcery.common.data.research.PlayerPerkData;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.server.PktSyncPerkActivity;
import hellfirepvp.astralsorcery.common.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.PerkCooldownHelper;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.source.AttributeConverterProvider;
import hellfirepvp.astralsorcery.common.perk.source.AttributeModifierProvider;
import hellfirepvp.astralsorcery.common.perk.source.ModifierManager;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;

public class PerkEffectHelper {
    private PerkEffectHelper() {
    }

    public static void onPlayerConnectEvent(ServerPlayerEntity player) {
        PerkEffectHelper.modifyAllPerks((PlayerEntity)player, LogicalSide.SERVER, Action.ADD);
        CompoundNBT asData = NBTHelper.getPersistentData((Entity)player);
        if (asData.func_150297_b("health", 5)) {
            player.func_70606_j(asData.func_74760_g("health"));
        }
        PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)player, new PktSyncPerkActivity(PktSyncPerkActivity.Type.UNLOCKALL));
    }

    public static void onPlayerDisconnectEvent(ServerPlayerEntity player) {
        PerkEffectHelper.modifyAllPerks((PlayerEntity)player, LogicalSide.SERVER, Action.REMOVE);
        NBTHelper.getPersistentData((Entity)player).func_74776_a("health", player.func_110143_aJ());
    }

    public static void onPlayerCloneEvent(ServerPlayerEntity original, ServerPlayerEntity newPlayer) {
        PerkEffectHelper.modifyAllPerks((PlayerEntity)original, LogicalSide.SERVER, Action.REMOVE);
        PerkEffectHelper.modifyAllPerks((PlayerEntity)newPlayer, LogicalSide.SERVER, Action.ADD);
        PerkCooldownHelper.removeAllCooldowns((PlayerEntity)original, LogicalSide.SERVER);
        PacketChannel.CHANNEL.sendToPlayer((PlayerEntity)newPlayer, new PktSyncPerkActivity(PktSyncPerkActivity.Type.UNLOCKALL));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientChangePerkData(AbstractPerk perk, CompoundNBT oldData, CompoundNBT newData) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PlayerProgress progress = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.CLIENT);
        PlayerPerkData perkData = progress.getPerkData();
        if (!perkData.hasPerkAllocation(perk)) {
            return;
        }
        perkData.updatePerkData(perk, oldData);
        PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.CLIENT, perk, Action.REMOVE);
        perkData.updatePerkData(perk, newData);
        PerkEffectHelper.modifySource((PlayerEntity)player, LogicalSide.CLIENT, perk, Action.ADD);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientClearAllPerks() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PlayerProgress progress = ResearchHelper.getProgress((PlayerEntity)player, LogicalSide.CLIENT);
        if (!progress.isValid()) {
            return;
        }
        PerkAttributeMap attr = PerkAttributeHelper.getOrCreateMap((PlayerEntity)player, LogicalSide.CLIENT);
        for (ModifierSource source : ModifierManager.getAppliedModifiers((PlayerEntity)player, LogicalSide.CLIENT)) {
            if (!(source instanceof AbstractPerk)) continue;
            PerkEffectHelper.removeSource(attr, (PlayerEntity)player, LogicalSide.CLIENT, source);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientRefreshAllPerks() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        PerkEffectHelper.modifyAllPerks((PlayerEntity)player, LogicalSide.CLIENT, Action.ADD);
        PerkCooldownHelper.removeAllCooldowns((PlayerEntity)player, LogicalSide.CLIENT);
    }

    private static void modifyAllPerks(PlayerEntity player, LogicalSide side, Action action) {
        ResearchHelper.getProgress(player, side).getPerkData().getEffectGrantingPerks().forEach(perk -> PerkEffectHelper.modifySource(player, side, perk, action));
    }

    public static void updateSource(PlayerEntity player, LogicalSide side, ModifierSource oldSource, ModifierSource newSource) {
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        if (!progress.isValid()) {
            return;
        }
        PerkAttributeMap attributeMap = PerkAttributeHelper.getOrCreateMap(player, side);
        attributeMap.write(() -> {
            if (ModifierManager.isModifierApplied(player, side, oldSource)) {
                PerkEffectHelper.removeSource(attributeMap, player, side, oldSource);
            }
            if (!ModifierManager.isModifierApplied(player, side, newSource) && newSource.canApplySource(player, side)) {
                PerkEffectHelper.applySource(attributeMap, player, side, newSource);
            }
        });
    }

    public static <T extends ModifierSource> void modifySources(PlayerEntity player, LogicalSide side, Collection<T> sources, Action action) {
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        if (!progress.isValid()) {
            return;
        }
        PerkAttributeMap attributeMap = PerkAttributeHelper.getOrCreateMap(player, side);
        for (ModifierSource src : sources) {
            if (action.isRemove()) {
                if (!ModifierManager.isModifierApplied(player, side, src)) continue;
                attributeMap.write(() -> PerkEffectHelper.removeSource(attributeMap, player, side, src));
                continue;
            }
            if (ModifierManager.isModifierApplied(player, side, src) || !src.canApplySource(player, side)) continue;
            attributeMap.write(() -> PerkEffectHelper.applySource(attributeMap, player, side, src));
        }
    }

    public static void modifySource(PlayerEntity player, LogicalSide side, ModifierSource source, Action action) {
        PlayerProgress progress = ResearchHelper.getProgress(player, side);
        if (!progress.isValid()) {
            return;
        }
        PerkAttributeMap attributeMap = PerkAttributeHelper.getOrCreateMap(player, side);
        if (action.isRemove()) {
            if (ModifierManager.isModifierApplied(player, side, source)) {
                attributeMap.write(() -> PerkEffectHelper.removeSource(attributeMap, player, side, source));
            }
        } else if (!ModifierManager.isModifierApplied(player, side, source) && source.canApplySource(player, side)) {
            attributeMap.write(() -> PerkEffectHelper.applySource(attributeMap, player, side, source));
        }
    }

    private static void applySource(PerkAttributeMap attrMap, PlayerEntity player, LogicalSide side, ModifierSource add) {
        Set<ModifierSource> sources = ModifierManager.getAppliedModifiers(player, side);
        sources.forEach(source -> {
            PerkEffectHelper.removeModifiers(source, attrMap, player, side);
            ModifierManager.removeModifier(player, side, source);
        });
        if (add instanceof AttributeConverterProvider) {
            ((AttributeConverterProvider)((Object)add)).getConverters(player, side, false).forEach(c -> attrMap.applyConverter(player, (PerkConverter)((Object)c)));
        }
        Collection<PerkAttributeModifier> newModifiers = PerkEffectHelper.applyModifiers(add, attrMap, player, side);
        sources.forEach(source -> {
            PerkEffectHelper.applyModifiers(source, attrMap, player, side);
            ModifierManager.addModifier(player, side, source);
        });
        ModifierManager.addModifier(player, side, add);
        newModifiers.forEach(mod -> mod.getAttributeType().onApply(player, side, add));
    }

    private static Collection<PerkAttributeModifier> applyModifiers(ModifierSource source, PerkAttributeMap attrMap, PlayerEntity player, LogicalSide side) {
        ArrayList<PerkAttributeModifier> addedModifiers = new ArrayList<PerkAttributeModifier>();
        if (source instanceof AttributeModifierProvider) {
            for (PerkAttributeModifier modifier : ((AttributeModifierProvider)((Object)source)).getModifiers(player, side, false)) {
                addedModifiers.addAll(attrMap.applyModifier(player, modifier, source));
            }
        }
        return addedModifiers;
    }

    private static void removeSource(PerkAttributeMap attrMap, PlayerEntity player, LogicalSide side, ModifierSource remove) {
        ModifierManager.removeModifier(player, side, remove);
        Set<ModifierSource> sources = ModifierManager.getAppliedModifiers(player, side);
        sources.forEach(source -> {
            PerkEffectHelper.removeModifiers(source, attrMap, player, side);
            ModifierManager.removeModifier(player, side, source);
        });
        Collection<PerkAttributeModifier> removedModifiers = PerkEffectHelper.removeModifiers(remove, attrMap, player, side);
        if (remove instanceof AttributeConverterProvider) {
            ((AttributeConverterProvider)((Object)remove)).getConverters(player, side, false).forEach(c -> attrMap.removeConverter(player, (PerkConverter)((Object)c)));
        }
        sources.forEach(source -> {
            PerkEffectHelper.applyModifiers(source, attrMap, player, side);
            ModifierManager.addModifier(player, side, source);
        });
        PerkAttributeMap map = PerkAttributeHelper.getOrCreateMap(player, side);
        removedModifiers.forEach(mod -> mod.getAttributeType().onRemove(player, side, !map.hasModifiers(mod.getAttributeType()), remove));
    }

    private static Collection<PerkAttributeModifier> removeModifiers(ModifierSource source, PerkAttributeMap attrMap, PlayerEntity player, LogicalSide side) {
        ArrayList<PerkAttributeModifier> removedModifiers = new ArrayList<PerkAttributeModifier>();
        if (source instanceof AttributeModifierProvider) {
            for (PerkAttributeModifier modifier : ((AttributeModifierProvider)((Object)source)).getModifiers(player, side, false)) {
                removedModifiers.addAll(attrMap.removeModifier(player, modifier, source));
            }
        }
        return removedModifiers;
    }

    public static enum Action {
        ADD,
        REMOVE;


        private boolean isRemove() {
            return this == REMOVE;
        }
    }
}

