/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.reader;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeLimiter;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeMap;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.reader.PerkStatistic;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class ReaderFlatAttribute
extends PerkAttributeReader {
    private final double defaultValue;
    private boolean formatAsDecimal = false;

    public ReaderFlatAttribute(PerkAttributeType type, double defaultValue) {
        super(type);
        this.defaultValue = defaultValue;
    }

    public <T extends ReaderFlatAttribute> T formatAsDecimal() {
        this.formatAsDecimal = true;
        return (T)((Object)this);
    }

    @Override
    public double getDefaultValue(PerkAttributeMap statMap, PlayerEntity player, LogicalSide side) {
        return this.defaultValue;
    }

    @Override
    public double getModifierValueForMode(PerkAttributeMap statMap, PlayerEntity player, LogicalSide side, ModifierType mode) {
        return statMap.getModifier(player, ResearchHelper.getProgress(player, side), this.getType(), mode);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PerkStatistic getStatistics(PerkAttributeMap statMap, PlayerEntity player) {
        String limitStr = "";
        Double limit = null;
        if (PerkAttributeLimiter.hasLimit(this.getType())) {
            Pair<Double, Double> limits = PerkAttributeLimiter.getLimit(this.getType());
            limit = (Double)limits.getRight();
            limitStr = I18n.func_135052_a((String)"perk.reader.astralsorcery.limit.default", (Object[])new Object[]{MathHelper.func_76128_c((double)limit)});
        }
        double value = statMap.modifyValue(player, ResearchHelper.getProgress(player, LogicalSide.CLIENT), this.getType(), (float)this.getDefaultValue(statMap, player, LogicalSide.CLIENT));
        String postProcess = "";
        double post = AttributeEvent.postProcessModded(player, this.getType(), value);
        if (Math.abs(value - post) > 1.0E-4 && (limit == null || Math.abs(post - limit) > 1.0E-4)) {
            if (Math.abs(post) >= 1.0E-4) {
                postProcess = I18n.func_135052_a((String)"perk.reader.astralsorcery.postprocess.default", (Object[])new Object[]{this.formatForDisplay(post)});
            }
            value = post;
        }
        return new PerkStatistic(this.getType(), this.formatForDisplay(value), limitStr, postProcess);
    }

    protected String formatForDisplay(double value) {
        String valueStr = this.formatAsDecimal ? ReaderFlatAttribute.formatDecimal(value) : String.valueOf(MathHelper.func_76128_c((double)value));
        return (value >= 0.0 ? "+" : "") + valueStr;
    }
}

