/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.reader.PerkAttributeReader;
import hellfirepvp.astralsorcery.common.perk.reader.ReaderAddedPercentage;
import hellfirepvp.astralsorcery.common.perk.reader.ReaderBreakSpeed;
import hellfirepvp.astralsorcery.common.perk.reader.ReaderFlatAttribute;
import hellfirepvp.astralsorcery.common.perk.reader.ReaderPercentageAttribute;
import hellfirepvp.astralsorcery.common.perk.reader.ReaderVanillaAttribute;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryPerkAttributeReaders {
    private RegistryPerkAttributeReaders() {
    }

    public static void init() {
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_MELEE_DAMAGE, RegistryPerkAttributeReaders.ref("generic.attack_damage")).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_HEALTH, RegistryPerkAttributeReaders.ref("generic.max_health")));
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_MOVESPEED, RegistryPerkAttributeReaders.ref("generic.movement_speed")).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_SWIMSPEED, (RegistryObject<Attribute>)ForgeMod.SWIM_SPEED).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_ARMOR, RegistryPerkAttributeReaders.ref("generic.armor")));
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_ARMOR_TOUGHNESS, RegistryPerkAttributeReaders.ref("generic.armor_toughness")));
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_ATTACK_SPEED, RegistryPerkAttributeReaders.ref("generic.attack_speed")).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_REACH, (RegistryObject<Attribute>)ForgeMod.REACH_DISTANCE).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderVanillaAttribute(PerkAttributeTypesAS.ATTR_TYPE_LUCK, RegistryPerkAttributeReaders.ref("generic.luck")).formatAsDecimal());
        RegistryPerkAttributeReaders.register(new ReaderFlatAttribute(PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_MAXIMUM, 1000.0)).formatAsDecimal();
        RegistryPerkAttributeReaders.register(new ReaderFlatAttribute(PerkAttributeTypesAS.ATTR_TYPE_MINING_SIZE, 0.0));
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_ALIGNMENT_CHARGE_REGENERATION);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_CRIT_MULTIPLIER);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_ALL_ELEMENTAL_RESIST);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_PROJ_DAMAGE);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_PROJ_SPEED);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_LIFE_RECOVERY);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_POTION_DURATION);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_ENCH_EFFECT);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_DODGE);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_CRIT_CHANCE);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_ATTACK_LIFE_LEECH);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_INC_THORNS);
        RegistryPerkAttributeReaders.registerDefaultReader(PerkAttributeTypesAS.ATTR_TYPE_COOLDOWN_REDUCTION);
        RegistryPerkAttributeReaders.register(new ReaderBreakSpeed(PerkAttributeTypesAS.ATTR_TYPE_INC_HARVEST_SPEED));
    }

    private static RegistryObject<Attribute> ref(String key) {
        return RegistryObject.of((ResourceLocation)new ResourceLocation(key), (IForgeRegistry)ForgeRegistries.ATTRIBUTES);
    }

    private static PerkAttributeReader registerDefaultReader(PerkAttributeType type) {
        if (type.isMultiplicative()) {
            return RegistryPerkAttributeReaders.register(new ReaderPercentageAttribute(type));
        }
        return RegistryPerkAttributeReaders.register(new ReaderAddedPercentage(type));
    }

    private static <T extends PerkAttributeReader> T register(T reader) {
        AstralSorcery.getProxy().getRegistryPrimer().register(reader);
        return reader;
    }
}

