/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.block.BlockGeometry;
import hellfirepvp.astralsorcery.common.util.data.BiDiPair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;

public class BlockSymmetryHelper {
    public SymmetryResult getDotSymmetry(IBlockReader world, BlockPos center, int radiusLayer, boolean allowMirrorSymmetry, Predicate<BlockState> applicableStateFilter) {
        List<BlockPos> layerPositions = BlockGeometry.getHollowSphere(radiusLayer + 1, radiusLayer);
        SymmetryResult result = new SymmetryResult(layerPositions.size());
        HashSet<BlockPos> visitedBlocks = new HashSet<BlockPos>();
        for (BlockPos offset : layerPositions) {
            BlockPos at = center.func_177971_a((Vector3i)offset);
            if (visitedBlocks.contains(at)) continue;
            visitedBlocks.add(at);
            BlockState state = world.func_180495_p(at);
            if (offset.func_177958_n() == 0 || offset.func_177956_o() == 0 || offset.func_177952_p() == 0) {
                if (state.isAir(world, at)) continue;
                result.fillerBlocks.add(at);
                continue;
            }
            if (applicableStateFilter.test(state)) {
                BlockPos dotSym = center.func_177973_b((Vector3i)offset);
                BlockState dotState = world.func_180495_p(dotSym);
                if (applicableStateFilter.test(dotState)) {
                    result.symmetryPairs.add(new BiDiPair<BlockPos, BlockPos>(at, dotSym));
                    if (!allowMirrorSymmetry) {
                        BlockSymmetryHelper.checkMirrorSymmetry(world, new Vector3i(-offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p()), center, result, visitedBlocks);
                        BlockSymmetryHelper.checkMirrorSymmetry(world, new Vector3i(offset.func_177958_n(), -offset.func_177956_o(), offset.func_177952_p()), center, result, visitedBlocks);
                        BlockSymmetryHelper.checkMirrorSymmetry(world, new Vector3i(offset.func_177958_n(), offset.func_177956_o(), -offset.func_177952_p()), center, result, visitedBlocks);
                    }
                } else if (!dotState.isAir(world, dotSym)) {
                    result.fillerBlocks.add(at);
                    result.fillerBlocks.add(dotSym);
                }
                visitedBlocks.add(dotSym);
                continue;
            }
            if (state.isAir(world, at)) continue;
            result.fillerBlocks.add(at);
        }
        result.density = ((float)result.fillerBlocks.size() + (float)result.symmetryPairs.size() * 2.0f) / (float)result.totalCount;
        return result;
    }

    private static void checkMirrorSymmetry(IBlockReader world, Vector3i offset, BlockPos center, SymmetryResult result, Set<BlockPos> visitedBlocks) {
        BlockPos at = center.func_177971_a(offset);
        BlockState state = world.func_180495_p(at);
        visitedBlocks.add(at);
        if (!state.isAir(world, at)) {
            result.fillerBlocks.add(at);
        }
        BlockPos dotSym = center.func_177973_b(offset);
        BlockState dotState = world.func_180495_p(dotSym);
        visitedBlocks.add(dotSym);
        if (!dotState.isAir(world, dotSym)) {
            result.fillerBlocks.add(at);
        }
    }

    public static class SymmetryResult {
        private final int totalCount;
        private float density = 0.0f;
        private final Set<BiDiPair<BlockPos, BlockPos>> symmetryPairs = new HashSet<BiDiPair<BlockPos, BlockPos>>();
        private final Set<BlockPos> fillerBlocks = new HashSet<BlockPos>();

        private SymmetryResult(int totalCount) {
            this.totalCount = totalCount;
        }

        public float getDensity() {
            return this.density;
        }

        public Set<BiDiPair<BlockPos, BlockPos>> getSymmetryPairs() {
            return this.symmetryPairs;
        }

        public Set<BlockPos> getFillerBlocks() {
            return this.fillerBlocks;
        }
    }
}

