/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.time;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.common.data.config.registry.TileAccelerationBlacklistRegistry;
import hellfirepvp.astralsorcery.common.network.play.server.PktPlayEffect;
import hellfirepvp.astralsorcery.common.util.data.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.time.TimeStopZone;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TimeStopEffectHelper {
    private static final Random rand = new Random();
    @Nonnull
    private final BlockPos position;
    private final float range;
    private final TimeStopZone.EntityTargetController targetController;

    private TimeStopEffectHelper(@Nonnull BlockPos position, float range, TimeStopZone.EntityTargetController targetController) {
        this.position = position;
        this.range = range;
        this.targetController = targetController;
    }

    static TimeStopEffectHelper fromZone(TimeStopZone zone) {
        return new TimeStopEffectHelper(zone.offset, zone.range, zone.targetController);
    }

    @Nonnull
    public BlockPos getPosition() {
        return this.position;
    }

    public float getRange() {
        return this.range;
    }

    public TimeStopZone.EntityTargetController getTargetController() {
        return this.targetController;
    }

    @OnlyIn(value=Dist.CLIENT)
    static void playEntityParticles(LivingEntity e) {
        EntitySize size = e.func_213305_a(e.func_213283_Z());
        double x = e.func_226277_ct_() - (double)(size.field_220315_a / 2.0f) + (double)(rand.nextFloat() * size.field_220315_a);
        double y = e.func_226278_cu_() + (double)(rand.nextFloat() * size.field_220316_b);
        double z = e.func_226281_cx_() - (double)(size.field_220315_a / 2.0f) + (double)(rand.nextFloat() * size.field_220315_a);
        TimeStopEffectHelper.playParticles(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playEntityParticles(PktPlayEffect ev) {
        Vector3 at = ByteBufUtils.readVector(ev.getExtraData());
        TimeStopEffectHelper.playParticles(at.getX(), at.getY(), at.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    static void playParticles(double x, double y, double z) {
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(new Vector3(x, y, z))).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.WHITE)).setScaleMultiplier(0.3f + rand.nextFloat() * 0.5f)).setMaxAge(40 + rand.nextInt(20));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playClientTickEffect() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        List entities = world.func_175647_a(LivingEntity.class, new AxisAlignedBB((double)(-this.range), (double)(-this.range), (double)(-this.range), (double)this.range, (double)this.range, (double)this.range).func_72317_d((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p()), EntityPredicates.func_188443_a((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p(), (double)this.range));
        for (LivingEntity e : entities) {
            if (e == null || !e.func_70089_S() || !this.targetController.shouldFreezeEntity(e) || rand.nextInt(3) != 0) continue;
            TimeStopEffectHelper.playEntityParticles(e);
        }
        int minX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() - this.range) / 16.0));
        int maxX = MathHelper.func_76128_c((double)((double)((float)this.position.func_177958_n() + this.range) / 16.0));
        int minZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() - this.range) / 16.0));
        int maxZ = MathHelper.func_76128_c((double)((double)((float)this.position.func_177952_p() + this.range) / 16.0));
        for (int xx = minX; xx <= maxX; ++xx) {
            for (int zz = minZ; zz <= maxZ; ++zz) {
                Chunk ch = world.func_212866_a_(xx, zz);
                if (ch.func_76621_g()) continue;
                Map map = ch.func_177434_r();
                for (Map.Entry teEntry : map.entrySet()) {
                    TileEntity te = (TileEntity)teEntry.getValue();
                    if (!TileAccelerationBlacklistRegistry.INSTANCE.canBeInfluenced(te) || !te.func_174877_v().func_218141_a((Vector3i)this.position, (double)this.range)) continue;
                    double x = (float)te.func_174877_v().func_177958_n() + rand.nextFloat();
                    double y = (float)te.func_174877_v().func_177956_o() + rand.nextFloat();
                    double z = (float)te.func_174877_v().func_177952_p() + rand.nextFloat();
                    TimeStopEffectHelper.playParticles(x, y, z);
                }
            }
        }
        for (int i = 0; i < 10; ++i) {
            Vector3 pos = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vector3i)this.position);
            TimeStopEffectHelper.playParticles(pos.getX(), pos.getY(), pos.getZ());
        }
        if (rand.nextInt(4) == 0) {
            Vector3 rand2;
            Vector3 rand1 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vector3i)this.position);
            if (rand1.distance(rand2 = Vector3.random().normalize().multiply(rand.nextFloat() * this.range).add((Vector3i)this.position)) > 10.0) {
                Vector3 dir = rand1.vectorFromHereTo(rand2);
                rand2 = rand1.clone().add(dir.normalize().multiply(10));
            }
            ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(rand1)).makeDefault(rand2).color(VFXColorFunction.WHITE);
        }
    }

    @Nonnull
    public CompoundNBT serializeNBT() {
        CompoundNBT out = new CompoundNBT();
        NBTHelper.writeBlockPosToNBT(this.position, out);
        out.func_74776_a("range", this.range);
        out.func_218657_a("targetController", (INBT)this.targetController.serializeNBT());
        return out;
    }

    @Nonnull
    public static TimeStopEffectHelper deserializeNBT(CompoundNBT cmp) {
        BlockPos at = NBTHelper.readBlockPosFromNBT(cmp);
        float range = cmp.func_74760_g("range");
        return new TimeStopEffectHelper(at, range, TimeStopZone.EntityTargetController.deserializeNBT(cmp.func_74775_l("targetController")));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStopEffectHelper that = (TimeStopEffectHelper)o;
        return Float.compare(that.range, this.range) == 0 && this.position.equals((Object)that.position);
    }

    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + (this.range != 0.0f ? Float.floatToIntBits(this.range) : 0);
        return result;
    }
}

