/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.world;

import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.play.client.PktRequestSeed;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WorldSeedCache {
    private static long lastServerQuery = 0L;
    private static int activeSession = 0;
    private static final Map<RegistryKey<World>, Long> cacheSeedLookup = new HashMap<RegistryKey<World>, Long>();

    @OnlyIn(value=Dist.CLIENT)
    public static void clearClient() {
        ++activeSession;
        cacheSeedLookup.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateSeedCache(RegistryKey<World> dim, int session, long seed) {
        if (activeSession == session) {
            cacheSeedLookup.put(dim, seed);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Optional<Long> getSeedIfPresent(RegistryKey<World> dim) {
        if (dim == null) {
            return Optional.empty();
        }
        if (!cacheSeedLookup.containsKey(dim)) {
            long current = System.currentTimeMillis();
            if (current - lastServerQuery > 5000L) {
                lastServerQuery = current;
                PktRequestSeed req = new PktRequestSeed(++activeSession, dim);
                PacketChannel.CHANNEL.sendToServer(req);
            }
            return Optional.empty();
        }
        return Optional.of(cacheSeedLookup.get(dim));
    }
}

