/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import mod.beethoven92.betterendforge.common.block.EndSignBlock;
import mod.beethoven92.betterendforge.common.init.ModItems;
import mod.beethoven92.betterendforge.common.tileentity.ESignTileEntity;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WoodType;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.tileentity.SignTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextProperties;

public class EndSignTileEntityRenderer
extends TileEntityRenderer<ESignTileEntity> {
    private static final HashMap<Block, RenderType> LAYERS = Maps.newHashMap();
    private static RenderType defaultLayer = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("textures/entity/sign/oak.png"));
    private final SignTileEntityRenderer.SignModel model = new SignTileEntityRenderer.SignModel();

    public EndSignTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ESignTileEntity signBlockEntity, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer provider, int light, int overlay) {
        BlockState state = signBlockEntity.func_195044_w();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        float angle = -((float)((Integer)state.func_177229_b((Property)StandingSignBlock.field_176413_a) * 360) / 16.0f);
        BlockState blockState = signBlockEntity.func_195044_w();
        if (((Boolean)blockState.func_177229_b((Property)EndSignBlock.FLOOR)).booleanValue()) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
            this.model.field_78165_b.field_78806_j = true;
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle + 180.0f));
            matrixStack.func_227861_a_(0.0, -0.3125, -0.4375);
            this.model.field_78165_b.field_78806_j = false;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(0.6666667f, -0.6666667f, -0.6666667f);
        IVertexBuilder vertexConsumer = EndSignTileEntityRenderer.getConsumer(provider, state.func_177230_c());
        this.model.field_78166_a.func_228308_a_(matrixStack, vertexConsumer, light, overlay);
        this.model.field_78165_b.func_228308_a_(matrixStack, vertexConsumer, light, overlay);
        matrixStack.func_227865_b_();
        FontRenderer textRenderer = this.field_228858_b_.func_147548_a();
        matrixStack.func_227861_a_(0.0, 0.3333333432674408, 0.046666666865348816);
        matrixStack.func_227862_a_(0.010416667f, -0.010416667f, 0.010416667f);
        int m = signBlockEntity.getTextColor().func_218388_g();
        int n = (int)((double)NativeImage.func_227791_b_((int)m) * 0.4);
        int o = (int)((double)NativeImage.func_227793_c_((int)m) * 0.4);
        int p = (int)((double)NativeImage.func_227795_d_((int)m) * 0.4);
        int q = NativeImage.func_227787_a_((int)0, (int)p, (int)o, (int)n);
        for (int s = 0; s < 4; ++s) {
            IReorderingProcessor orderedText = signBlockEntity.getTextBeingEditedOnRow(s, text -> {
                List list = textRenderer.func_238425_b_((ITextProperties)text, 90);
                return list.isEmpty() ? IReorderingProcessor.field_242232_a : (IReorderingProcessor)list.get(0);
            });
            if (orderedText == null) continue;
            float t = -textRenderer.func_243245_a(orderedText) / 2;
            textRenderer.func_238416_a_(orderedText, t, (float)(s * 10 - 20), q, false, matrixStack.func_227866_c_().func_227870_a_(), provider, false, 0, light);
        }
        matrixStack.func_227865_b_();
    }

    public static RenderMaterial getModelTexture(Block block) {
        WoodType signType2 = block instanceof AbstractSignBlock ? ((AbstractSignBlock)block).func_226944_c_() : WoodType.field_227038_a_;
        return Atlases.func_228773_a_((WoodType)signType2);
    }

    public static IVertexBuilder getConsumer(IRenderTypeBuffer provider, Block block) {
        return provider.getBuffer(LAYERS.getOrDefault(block, defaultLayer));
    }

    static {
        ModItems.ITEMS.getEntries().forEach(item -> {
            Block block;
            if (item.get() instanceof BlockItem && (block = ((BlockItem)item.get()).func_179223_d()) instanceof EndSignBlock) {
                String name = block.getRegistryName().func_110623_a();
                RenderType layer = RenderType.func_228634_a_((ResourceLocation)new ResourceLocation("betterendforge", "textures/entity/sign/" + name + ".png"));
                LAYERS.put(block, layer);
            }
        });
    }
}

