/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mod.beethoven92.betterendforge.common.block.AuroraCrystalBlock;
import mod.beethoven92.betterendforge.common.util.ColorHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class EternalCrystalRenderer {
    private static final ResourceLocation CRYSTAL_TEXTURE = new ResourceLocation("betterendforge", "textures/entity/eternal_crystal.png");
    private static final RenderType RENDER_LAYER = RenderType.func_228637_a_((ResourceLocation)CRYSTAL_TEXTURE, (boolean)true);
    private static final ModelRenderer[] SHARDS = new ModelRenderer[4];
    private static final ModelRenderer CORE;

    public static void render(int age, float tickDelta, MatrixStack matrices, IRenderTypeBuffer bufferIn, int light) {
        IVertexBuilder iVertexBuilder = bufferIn.getBuffer(RENDER_LAYER);
        float[] colors = EternalCrystalRenderer.colors(age);
        float rotation = ((float)age + tickDelta) / 25.0f + 6.0f;
        matrices.func_227860_a_();
        matrices.func_227862_a_(0.6f, 0.6f, 0.6f);
        matrices.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(rotation));
        CORE.func_228309_a_(matrices, iVertexBuilder, light, OverlayTexture.field_229196_a_, colors[0], colors[1], colors[2], colors[3]);
        for (int i = 0; i < 4; ++i) {
            matrices.func_227860_a_();
            float offset = MathHelper.func_76126_a((float)(rotation * 2.0f + (float)i)) * 0.15f;
            matrices.func_227861_a_(0.0, (double)offset, 0.0);
            SHARDS[i].func_228309_a_(matrices, iVertexBuilder, light, OverlayTexture.field_229196_a_, colors[0], colors[1], colors[2], colors[3]);
            matrices.func_227865_b_();
        }
        matrices.func_227865_b_();
    }

    public static float[] colors(int age) {
        double delta = (double)age * 0.01;
        int index = ModMathHelper.floor(delta);
        int index2 = index + 1 & 3;
        delta -= (double)index;
        Vector3i color1 = AuroraCrystalBlock.COLORS[index &= 3];
        Vector3i color2 = AuroraCrystalBlock.COLORS[index2];
        int r = ModMathHelper.floor(MathHelper.func_219803_d((double)delta, (double)color1.func_177958_n(), (double)color2.func_177958_n()));
        int g = ModMathHelper.floor(MathHelper.func_219803_d((double)delta, (double)color1.func_177956_o(), (double)color2.func_177956_o()));
        int b = ModMathHelper.floor(MathHelper.func_219803_d((double)delta, (double)color1.func_177952_p(), (double)color2.func_177952_p()));
        return ColorHelper.toFloatArray(ModMathHelper.color(r, g, b));
    }

    static {
        EternalCrystalRenderer.SHARDS[0] = new ModelRenderer(16, 16, 2, 4).func_228300_a_(-5.0f, 1.0f, -3.0f, 2.0f, 8.0f, 2.0f);
        EternalCrystalRenderer.SHARDS[1] = new ModelRenderer(16, 16, 2, 4).func_228300_a_(3.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f);
        EternalCrystalRenderer.SHARDS[2] = new ModelRenderer(16, 16, 2, 4).func_228300_a_(-1.0f, 0.0f, -5.0f, 2.0f, 4.0f, 2.0f);
        EternalCrystalRenderer.SHARDS[3] = new ModelRenderer(16, 16, 2, 4).func_228300_a_(0.0f, 3.0f, 4.0f, 2.0f, 6.0f, 2.0f);
        CORE = new ModelRenderer(16, 16, 0, 0);
        CORE.func_228300_a_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f);
    }
}

