/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import mod.beethoven92.betterendforge.common.teleporter.EndPortals;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.util.IStringSerializable;

public class BlockProperties {
    public static final EnumProperty<TripleShape> TRIPLE_SHAPE = EnumProperty.func_177709_a((String)"shape", TripleShape.class);
    public static final EnumProperty<PedestalState> PEDESTAL_STATE = EnumProperty.func_177709_a((String)"state", PedestalState.class);
    public static final EnumProperty<HydraluxShape> HYDRALUX_SHAPE = EnumProperty.func_177709_a((String)"shape", HydraluxShape.class);
    public static final EnumProperty<PentaShape> PENTA_SHAPE = EnumProperty.func_177709_a((String)"shape", PentaShape.class);
    public static final EnumProperty<CactusBottom> CACTUS_BOTTOM = EnumProperty.func_177709_a((String)"bottom", CactusBottom.class);
    public static final BooleanProperty HAS_ITEM = BooleanProperty.func_177716_a((String)"has_item");
    public static final BooleanProperty HAS_LIGHT = BooleanProperty.func_177716_a((String)"has_light");
    public static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"active");
    public static final BooleanProperty NATURAL = BooleanProperty.func_177716_a((String)"natural");
    public static final BooleanProperty IS_FLOOR = BooleanProperty.func_177716_a((String)"is_floor");
    public static final IntegerProperty ROTATION = IntegerProperty.func_177719_a((String)"rotation", (int)0, (int)3);
    public static final IntegerProperty FULLNESS = IntegerProperty.func_177719_a((String)"fullness", (int)0, (int)3);
    public static final IntegerProperty DESTRUCTION = IntegerProperty.func_177719_a((String)"destruction", (int)0, (int)2);
    public static final IntegerProperty DESTRUCTION_LONG = IntegerProperty.func_177719_a((String)"destruction", (int)0, (int)8);
    public static final IntegerProperty PORTAL = IntegerProperty.func_177719_a((String)"portal", (int)0, (int)EndPortals.getCount());
    public static final IntegerProperty SIZE = IntegerProperty.func_177719_a((String)"size", (int)0, (int)7);

    public static enum CactusBottom implements IStringSerializable
    {
        EMPTY("empty"),
        SAND("sand"),
        MOSS("moss");

        private final String name;

        private CactusBottom(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum LumecornShape implements IStringSerializable
    {
        LIGHT_TOP("light_top", 15),
        LIGHT_TOP_MIDDLE("light_top_middle", 15),
        LIGHT_MIDDLE("light_middle", 15),
        LIGHT_BOTTOM("light_bottom", 15),
        MIDDLE("middle", 0),
        BOTTOM_BIG("bottom_big", 0),
        BOTTOM_SMALL("bottom_small", 0);

        private final String name;
        private final int light;

        private LumecornShape(String name, int light) {
            this.name = name;
            this.light = light;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }
    }

    public static enum PentaShape implements IStringSerializable
    {
        BOTTOM("bottom"),
        PRE_BOTTOM("pre_bottom"),
        MIDDLE("middle"),
        PRE_TOP("pre_top"),
        TOP("top");

        private final String name;

        private PentaShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum HydraluxShape implements IStringSerializable
    {
        FLOWER_BIG_BOTTOM("flower_big_bottom", true),
        FLOWER_BIG_TOP("flower_big_top", true),
        FLOWER_SMALL_BOTTOM("flower_small_bottom", true),
        FLOWER_SMALL_TOP("flower_small_top", true),
        VINE("vine", false),
        ROOTS("roots", false);

        private final String name;
        private final boolean glow;

        private HydraluxShape(String name, boolean glow) {
            this.name = name;
            this.glow = glow;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean hasGlow() {
            return this.glow;
        }
    }

    public static enum PedestalState implements IStringSerializable
    {
        PEDESTAL_TOP("pedestal_top"),
        COLUMN_TOP("column_top"),
        BOTTOM("bottom"),
        PILLAR("pillar"),
        COLUMN("column"),
        DEFAULT("default");

        private final String name;

        private PedestalState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum TripleShape implements IStringSerializable
    {
        TOP("top", 0),
        MIDDLE("middle", 1),
        BOTTOM("bottom", 2);

        private final String name;
        private final int index;

        private TripleShape(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public static TripleShape fromIndex(int index) {
            return index > 1 ? BOTTOM : (index == 1 ? MIDDLE : TOP);
        }
    }
}

