/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.template.PedestalBlock;
import mod.beethoven92.betterendforge.common.rituals.InfusionRitual;
import mod.beethoven92.betterendforge.common.tileentity.InfusionPedestalTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InfusionPedestal
extends PedestalBlock {
    private static final VoxelShape SHAPE_DEFAULT;
    private static final VoxelShape SHAPE_PEDESTAL_TOP;

    public InfusionPedestal(AbstractBlock.Properties properties) {
        super(properties);
        this.height = 1.08f;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_203425_a((Block)this)) {
            switch ((BlockProperties.PedestalState)((Object)state.func_177229_b((Property)STATE))) {
                case PEDESTAL_TOP: {
                    return SHAPE_PEDESTAL_TOP;
                }
                case DEFAULT: {
                    return SHAPE_DEFAULT;
                }
            }
            return super.func_220053_a(state, worldIn, pos, context);
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K || !state.func_203425_a((Block)this)) {
            return ActionResultType.CONSUME;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        InfusionPedestalTileEntity pedestal = null;
        if (tileEntity instanceof InfusionPedestalTileEntity && !(pedestal = (InfusionPedestalTileEntity)tileEntity).isEmpty() && pedestal.hasRitual()) {
            if (pedestal.getRitual().hasRecipe()) {
                pedestal.getRitual().stop();
                return ActionResultType.SUCCESS;
            }
            if (pedestal.getRitual().checkRecipe()) {
                return ActionResultType.SUCCESS;
            }
        }
        ActionResultType result = ActionResultType.FAIL;
        if (handIn != null) {
            result = super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        if (result == ActionResultType.SUCCESS && pedestal != null) {
            if (pedestal.hasRitual()) {
                pedestal.getRitual().checkRecipe();
            } else {
                InfusionRitual ritual = new InfusionRitual(worldIn, pos);
                pedestal.linkRitual(ritual);
                ritual.checkRecipe();
            }
        }
        return result;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new InfusionPedestalTileEntity();
    }

    static {
        VoxelShape basinUp = Block.func_208617_a((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
        VoxelShape basinDown = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape pedestalTop = Block.func_208617_a((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);
        VoxelShape pedestalDefault = Block.func_208617_a((double)1.0, (double)13.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
        VoxelShape pillar = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0);
        VoxelShape pillarDefault = Block.func_208617_a((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
        VoxelShape eyeDefault = Block.func_208617_a((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape eyeTop = Block.func_208617_a((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape basin = VoxelShapes.func_197872_a((VoxelShape)basinDown, (VoxelShape)basinUp);
        SHAPE_DEFAULT = VoxelShapes.func_216384_a((VoxelShape)basin, (VoxelShape[])new VoxelShape[]{pillarDefault, pedestalDefault, eyeDefault});
        SHAPE_PEDESTAL_TOP = VoxelShapes.func_216384_a((VoxelShape)pillar, (VoxelShape[])new VoxelShape[]{pedestalTop, eyeTop});
    }
}

