/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.block;

import java.util.Random;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.TerrainBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TripleTerrainBlock
extends TerrainBlock {
    public static final EnumProperty<BlockProperties.TripleShape> SHAPE = BlockProperties.TRIPLE_SHAPE;

    public TripleTerrainBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.func_177229_b(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }
        return ActionResultType.FAIL;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction dir = context.func_196000_l();
        BlockProperties.TripleShape shape = dir == Direction.UP ? BlockProperties.TripleShape.BOTTOM : (dir == Direction.DOWN ? BlockProperties.TripleShape.TOP : BlockProperties.TripleShape.MIDDLE);
        return (BlockState)this.func_176223_P().func_206870_a(SHAPE, (Comparable)((Object)shape));
    }

    @Override
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockProperties.TripleShape shape = (BlockProperties.TripleShape)((Object)state.func_177229_b(SHAPE));
        if (shape == BlockProperties.TripleShape.BOTTOM) {
            super.func_225542_b_(state, world, pos, random);
            return;
        }
        if (random.nextInt(16) == 0) {
            boolean bottom = this.canSurviveBottom((IWorld)world, pos);
            if (shape == BlockProperties.TripleShape.TOP) {
                if (!bottom) {
                    world.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
                }
            } else {
                boolean top;
                boolean bl = top = TripleTerrainBlock.canSurvive(state, (IWorldReader)world, pos) || this.isMiddle(world.func_180495_p(pos.func_177984_a()));
                if (!top && !bottom) {
                    world.func_175656_a(pos, Blocks.field_150377_bs.func_176223_P());
                } else if (top && !bottom) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM)));
                } else if (!top && bottom) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP)));
                }
            }
        }
    }

    protected boolean canSurviveBottom(IWorld world, BlockPos pos) {
        BlockPos blockPos = pos.func_177977_b();
        BlockState blockState = world.func_180495_p(blockPos);
        if (this.isMiddle(blockState)) {
            return true;
        }
        if (blockState.func_204520_s().func_206882_g() == 8) {
            return false;
        }
        return !blockState.func_224755_d((IBlockReader)world, blockPos, Direction.UP);
    }

    protected boolean isMiddle(BlockState state) {
        return state.func_203425_a((Block)this) && state.func_177229_b(SHAPE) == BlockProperties.TripleShape.MIDDLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SHAPE});
    }
}

