/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.lootmodifier;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import mod.beethoven92.betterendforge.common.init.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class BetterEndMusicDiscLootModifier
extends LootModifier {
    private static final List<Supplier<Item>> DISCS = ImmutableList.of(ModItems.MUSIC_DISC_ENDSEEKER, ModItems.MUSIC_DISC_EO_DRACONA, ModItems.MUSIC_DISC_GRASPING_AT_STARS, ModItems.MUSIC_DISC_STRANGE_AND_ALIEN);
    private int min;
    private int max;

    public BetterEndMusicDiscLootModifier(ILootCondition[] conditionsIn, int min, int max) {
        super(conditionsIn);
        this.min = min;
        this.max = max;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        Random rand = context.func_216032_b();
        int count = rand.nextInt(this.max - this.min) + this.min;
        for (int i = 0; i < count; ++i) {
            generatedLoot.add(DISCS.get(rand.nextInt(DISCS.size())).get().func_190903_i());
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<BetterEndMusicDiscLootModifier> {
        public BetterEndMusicDiscLootModifier read(ResourceLocation name, JsonObject json, ILootCondition[] conditionsIn) {
            int max;
            int min = JSONUtils.func_151203_m((JsonObject)json, (String)"min");
            if (min >= (max = JSONUtils.func_151203_m((JsonObject)json, (String)"max"))) {
                throw new JsonSyntaxException("min has to be smaller than max");
            }
            return new BetterEndMusicDiscLootModifier(conditionsIn, min, max);
        }

        public JsonObject write(BetterEndMusicDiscLootModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("min", (Number)instance.min);
            json.addProperty("max", (Number)instance.max);
            return json;
        }
    }
}

