/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import mod.beethoven92.betterendforge.BetterEnd;
import mod.beethoven92.betterendforge.common.util.ColorExtractor;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColorHelper {
    private static Map<ResourceLocation, Integer> colorPalette = Maps.newHashMap();
    private static float[] floatBuffer = new float[4];

    public static float[] toFloatArray(int color) {
        ColorHelper.floatBuffer[0] = (float)(color >> 16 & 0xFF) / 255.0f;
        ColorHelper.floatBuffer[1] = (float)(color >> 8 & 0xFF) / 255.0f;
        ColorHelper.floatBuffer[2] = (float)(color & 0xFF) / 255.0f;
        ColorHelper.floatBuffer[3] = (float)(color >> 24 & 0xFF) / 255.0f;
        return floatBuffer;
    }

    public static int ABGRtoARGB(int color) {
        int a = color >> 24 & 0xFF;
        int b = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int r = color & 0xFF;
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int colorDistance(int color1, int color2) {
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        return ModMathHelper.pow2(r1 - r2) + ModMathHelper.pow2(g1 - g2) + ModMathHelper.pow2(b1 - b2);
    }

    public static int extractColor(Item item) {
        ResourceLocation id = Registry.field_212630_s.func_177774_c((Object)item);
        if (id.equals((Object)Registry.field_212630_s.func_212609_b())) {
            return -1;
        }
        if (colorPalette.containsKey(id)) {
            return colorPalette.get(id);
        }
        ResourceLocation texture = item instanceof BlockItem ? new ResourceLocation(id.func_110624_b(), "textures/block/" + id.func_110623_a() + ".png") : new ResourceLocation(id.func_110624_b(), "textures/item/" + id.func_110623_a() + ".png");
        NativeImage image = ColorHelper.loadImage(texture, 16, 16);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int i = 0; i < image.func_195702_a(); ++i) {
            for (int j = 0; j < 16; ++j) {
                int col = image.func_195709_a(i, j);
                if ((col >> 24 & 0xFF) <= 0) continue;
                colors.add(ColorHelper.ABGRtoARGB(col));
            }
        }
        image.close();
        if (colors.size() == 0) {
            return -1;
        }
        ColorExtractor extractor = new ColorExtractor(colors);
        int color = extractor.analize();
        colorPalette.put(id, color);
        return color;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NativeImage loadImage(ResourceLocation image, int w, int h) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IResourceManager resourceManager = minecraft.func_195551_G();
        if (!resourceManager.func_219533_b(image)) return new NativeImage(w, h, false);
        try (IResource resource = resourceManager.func_199002_a(image);){
            NativeImage nativeImage = NativeImage.func_195713_a((InputStream)resource.func_199027_b());
            return nativeImage;
        }
        catch (IOException e) {
            BetterEnd.LOGGER.warn("Can't load texture image: {}. Will be created empty image.", (Object)image);
            BetterEnd.LOGGER.warn("Cause: {}.", (Object)e.getMessage());
        }
        return new NativeImage(w, h, false);
    }
}

