/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util.sdf;

import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class PosInfo
implements Comparable<PosInfo> {
    private static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    private final Map<BlockPos, PosInfo> blocks;
    private final Map<BlockPos, PosInfo> add;
    private final BlockPos pos;
    private BlockState state;

    public static PosInfo create(Map<BlockPos, PosInfo> blocks, Map<BlockPos, PosInfo> add, BlockPos pos) {
        return new PosInfo(blocks, add, pos);
    }

    private PosInfo(Map<BlockPos, PosInfo> blocks, Map<BlockPos, PosInfo> add, BlockPos pos) {
        this.blocks = blocks;
        this.add = add;
        this.pos = pos;
        blocks.put(pos, this);
    }

    public BlockState getState() {
        return this.state;
    }

    public BlockState getState(BlockPos pos) {
        PosInfo info = this.blocks.get(pos);
        if (info == null) {
            info = this.add.get(pos);
            return info == null ? AIR : info.getState();
        }
        return info.getState();
    }

    public void setState(BlockState state) {
        this.state = state;
    }

    public void setState(BlockPos pos, BlockState state) {
        PosInfo info = this.blocks.get(pos);
        if (info != null) {
            info.setState(state);
        }
    }

    public BlockState getState(Direction dir) {
        PosInfo info = this.blocks.get(this.pos.func_177972_a(dir));
        if (info == null) {
            info = this.add.get(this.pos.func_177972_a(dir));
            return info == null ? AIR : info.getState();
        }
        return info.getState();
    }

    public BlockState getState(Direction dir, int distance) {
        PosInfo info = this.blocks.get(this.pos.func_177967_a(dir, distance));
        if (info == null) {
            return AIR;
        }
        return info.getState();
    }

    public BlockState getStateUp() {
        return this.getState(Direction.UP);
    }

    public BlockState getStateDown() {
        return this.getState(Direction.DOWN);
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PosInfo)) {
            return false;
        }
        return this.pos.equals((Object)((PosInfo)obj).pos);
    }

    @Override
    public int compareTo(PosInfo info) {
        return this.pos.func_177956_o() - info.pos.func_177956_o();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void setBlockPos(BlockPos pos, BlockState state) {
        PosInfo info = new PosInfo(this.blocks, this.add, pos);
        info.state = state;
        this.add.put(pos, info);
    }
}

