/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.util.sdf;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.sdf.PosInfo;
import mod.beethoven92.betterendforge.common.world.structure.StructureWorld;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;

public abstract class SDF {
    private List<Function<PosInfo, BlockState>> postProcesses = Lists.newArrayList();
    private Function<BlockState, Boolean> canReplace = state -> state.func_185904_a().func_76222_j();

    public abstract float getDistance(float var1, float var2, float var3);

    public abstract BlockState getBlockState(BlockPos var1);

    public SDF addPostProcess(Function<PosInfo, BlockState> postProcess) {
        this.postProcesses.add(postProcess);
        return this;
    }

    public SDF setReplaceFunction(Function<BlockState, Boolean> canReplace) {
        this.canReplace = canReplace;
        return this;
    }

    public void fillRecursive(IWorld world, BlockPos start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.func_189533_g((Vector3i)center).func_189536_c(dir);
                    BlockPos wpos = bPos.func_177971_a((Vector3i)start);
                    if (blocks.contains(bPos) || !this.canReplace.apply(world.func_180495_p(wpos)).booleanValue() || !(this.getDistance(bPos.func_177958_n(), bPos.func_177956_o(), bPos.func_177952_p()) < 0.0f)) continue;
                    BlockState state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.func_185334_h());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.func_180495_p(info.getPos())).booleanValue()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillArea(IWorld world, BlockPos center, AxisAlignedBB box) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        BlockPos.Mutable mut = new BlockPos.Mutable();
        int y = (int)box.field_72338_b;
        while ((double)y <= box.field_72337_e) {
            mut.func_185336_p(y);
            int x = (int)box.field_72340_a;
            while ((double)x <= box.field_72336_d) {
                mut.func_223471_o(x);
                int z = (int)box.field_72339_c;
                while ((double)z <= box.field_72334_f) {
                    BlockPos fpos;
                    mut.func_223472_q(z);
                    if (this.canReplace.apply(world.func_180495_p((BlockPos)mut)).booleanValue() && this.getDistance((fpos = mut.func_177973_b((Vector3i)center)).func_177958_n(), fpos.func_177956_o(), fpos.func_177952_p()) < 0.0f) {
                        PosInfo.create(mapWorld, addInfo, mut.func_185334_h()).setState(this.getBlockState((BlockPos)mut));
                    }
                    ++z;
                }
                ++x;
            }
            ++y;
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.func_180495_p(info.getPos())).booleanValue()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursiveIgnore(IWorld world, BlockPos start, Function<BlockState, Boolean> ignore) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.func_189533_g((Vector3i)center).func_189536_c(dir);
                    BlockPos wpos = bPos.func_177971_a((Vector3i)start);
                    BlockState state = world.func_180495_p(wpos);
                    boolean ign = ignore.apply(state);
                    if (blocks.contains(bPos) || !ign && !this.canReplace.apply(state).booleanValue() || !(this.getDistance(bPos.func_177958_n(), bPos.func_177956_o(), bPos.func_177952_p()) < 0.0f)) continue;
                    PosInfo.create(mapWorld, addInfo, wpos).setState(ign ? state : this.getBlockState((BlockPos)bPos));
                    add.add(bPos.func_185334_h());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        if (infos.size() > 0) {
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState()));
            infos.clear();
            infos.addAll(addInfo.values());
            Collections.sort(infos);
            this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
            infos.forEach(info -> {
                if (this.canReplace.apply(world.func_180495_p(info.getPos())).booleanValue()) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, info.getPos(), info.getState());
                }
            });
        }
    }

    public void fillRecursive(StructureWorld world, BlockPos start) {
        HashMap mapWorld = Maps.newHashMap();
        HashMap addInfo = Maps.newHashMap();
        HashSet blocks = Sets.newHashSet();
        HashSet ends = Sets.newHashSet();
        HashSet add = Sets.newHashSet();
        ends.add(new BlockPos(0, 0, 0));
        BlockPos.Mutable bPos = new BlockPos.Mutable();
        for (boolean run = true; run; run &= !ends.isEmpty()) {
            for (BlockPos center : ends) {
                for (Direction dir : Direction.values()) {
                    bPos.func_189533_g((Vector3i)center).func_189536_c(dir);
                    BlockPos wpos = bPos.func_177971_a((Vector3i)start);
                    if (blocks.contains(bPos) || !(this.getDistance(bPos.func_177958_n(), bPos.func_177956_o(), bPos.func_177952_p()) < 0.0f)) continue;
                    BlockState state = this.getBlockState(wpos);
                    PosInfo.create(mapWorld, addInfo, wpos).setState(state);
                    add.add(bPos.func_185334_h());
                }
            }
            blocks.addAll(ends);
            ends.clear();
            ends.addAll(add);
            add.clear();
        }
        ArrayList infos = new ArrayList(mapWorld.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
        infos.clear();
        infos.addAll(addInfo.values());
        Collections.sort(infos);
        this.postProcesses.forEach(postProcess -> infos.forEach(info -> info.setState((BlockState)postProcess.apply(info))));
        infos.forEach(info -> world.setBlock(info.getPos(), info.getState()));
    }
}

