/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import java.util.Random;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public abstract class InvertedScatterFeature
extends Feature<NoFeatureConfig> {
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    private final int radius;

    public InvertedScatterFeature(int radius) {
        super(NoFeatureConfig.field_236558_a_);
        this.radius = radius;
    }

    public abstract boolean canGenerate(ISeedReader var1, Random var2, BlockPos var3, BlockPos var4, float var5);

    public abstract void generate(ISeedReader var1, Random var2, BlockPos var3);

    public boolean generate(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos pos, NoFeatureConfig config) {
        int maxY = world.func_201676_a(Heightmap.Type.WORLD_SURFACE, pos.func_177958_n(), pos.func_177952_p());
        int minY = BlockHelper.upRay((IWorldReader)world, new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()), maxY);
        for (int y = maxY; y > minY; --y) {
            POS.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p());
            if (!world.func_180495_p((BlockPos)POS).func_196958_f() || world.func_180495_p(POS.func_177984_a()).func_196958_f()) continue;
            float r = ModMathHelper.randRange((float)this.radius * 0.5f, (float)this.radius, random);
            int count = ModMathHelper.floor(r * r * ModMathHelper.randRange(0.5f, 1.5f, random));
            for (int i = 0; i < count; ++i) {
                float pr = r * (float)Math.sqrt(random.nextFloat());
                float theta = random.nextFloat() * ((float)Math.PI * 2);
                float x = pr * (float)Math.cos(theta);
                float z = pr * (float)Math.sin(theta);
                POS.func_189532_c((double)((float)pos.func_177958_n() + x), (double)POS.func_177956_o(), (double)((float)pos.func_177952_p() + z));
                if (!this.canGenerate(world, random, pos, (BlockPos)POS, r)) continue;
                this.generate(world, random, (BlockPos)POS);
            }
        }
        return true;
    }
}

