/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.template.FurBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFDisplacement;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class TenaneaFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final Function<BlockState, Boolean> IGNORE;
    private static final List<Vector3f> SPLINE;
    private static final Direction[] DIRECTIONS;

    public TenaneaFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        float size = ModMathHelper.randRange(7, 10, rand);
        int count = (int)(size * 0.45f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = ModMathHelper.randRange(0.0f, (float)Math.PI * 2, rand);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + ModMathHelper.randRange(0.0f, var, rand) + start;
            List<Vector3f> spline = SplineHelper.copySpline(SPLINE);
            SplineHelper.rotateSpline(spline, angle);
            SplineHelper.scale(spline, size + ModMathHelper.randRange(0.0f, size * 0.5f, rand));
            SplineHelper.offsetParts(spline, rand, 1.0f, 0.0f, 1.0f);
            SplineHelper.fillSpline(spline, (IWorld)world, ((Block)ModBlocks.TENANEA.bark.get()).func_176223_P(), pos, REPLACE);
            Vector3f last = spline.get(spline.size() - 1);
            float leavesRadius = (size * 0.3f + ModMathHelper.randRange(0.8f, 1.5f, rand)) * 1.4f;
            OpenSimplexNoise noise = new OpenSimplexNoise(rand.nextLong());
            this.leavesBall(world, pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c()), leavesRadius, rand, noise);
        }
        return true;
    }

    private void leavesBall(ISeedReader world, BlockPos pos, float radius, Random random, OpenSimplexNoise noise) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock((BlockState)((Block)ModBlocks.TENANEA_LEAVES.get()).func_176223_P().func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(6)));
        SDFUnary sub = new SDFScale().setScale(5.0f).setSource(sphere);
        sub = new SDFTranslate().setTranslate(0.0f, -radius * 5.0f, 0.0f).setSource(sub);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.75f, 1.0f).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf((float)noise.eval((double)vec.func_195899_a() * 0.2, (double)vec.func_195900_b() * 0.2, (double)vec.func_195902_c() * 0.2) * 2.0f)).setSource(sphere);
        sphere = new SDFDisplacement().setFunction(vec -> Float.valueOf(ModMathHelper.randRange(-1.5f, 1.5f, random))).setSource(sphere);
        BlockPos.Mutable mut = new BlockPos.Mutable();
        for (Direction d1 : BlockHelper.HORIZONTAL_DIRECTIONS) {
            BlockPos p = mut.func_189533_g((Vector3i)pos).func_189536_c(Direction.UP).func_189536_c(d1).func_185334_h();
            BlockHelper.setWithoutUpdate((IWorldWriter)world, p, ((Block)ModBlocks.TENANEA.bark.get()).func_176223_P());
            for (Direction d2 : BlockHelper.HORIZONTAL_DIRECTIONS) {
                mut.func_189533_g((Vector3i)p).func_189536_c(Direction.UP).func_189536_c(d2);
                BlockHelper.setWithoutUpdate((IWorldWriter)world, p, ((Block)ModBlocks.TENANEA.bark.get()).func_176223_P());
            }
        }
        BlockState top = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.TOP));
        BlockState middle = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.MIDDLE));
        BlockState bottom = (BlockState)((Block)ModBlocks.TENANEA_FLOWERS.get()).func_176223_P().func_206870_a(BlockProperties.TRIPLE_SHAPE, (Comparable)((Object)BlockProperties.TripleShape.BOTTOM));
        BlockState outer = ((Block)ModBlocks.TENANEA_OUTER_LEAVES.get()).func_176223_P();
        ArrayList support = Lists.newArrayList();
        sphere.addPostProcess(info -> {
            if (random.nextInt(6) == 0 && info.getStateDown().func_196958_f()) {
                Direction[] d = info.getPos().func_177977_b();
                support.add(d);
            }
            if (random.nextInt(5) == 0) {
                for (Direction dir : Direction.values()) {
                    BlockState state = info.getState(dir, 2);
                    if (!state.func_196958_f()) continue;
                    return info.getState();
                }
                info.setState(((Block)ModBlocks.TENANEA.bark.get()).func_176223_P());
            }
            ModMathHelper.shuffle(DIRECTIONS, random);
            for (Direction d : DIRECTIONS) {
                if (!info.getState(d).func_196958_f()) continue;
                info.setBlockPos(info.getPos().func_177972_a(d), (BlockState)outer.func_206870_a((Property)FurBlock.FACING, (Comparable)d));
            }
            if (ModBlocks.TENANEA.isTreeLog(info.getState())) {
                for (int x = -6; x < 7; ++x) {
                    int ax = Math.abs(x);
                    mut.func_223471_o(x + info.getPos().func_177958_n());
                    for (int z = -6; z < 7; ++z) {
                        int az = Math.abs(z);
                        mut.func_223472_q(z + info.getPos().func_177952_p());
                        for (int y = -6; y < 7; ++y) {
                            int distance;
                            int ay = Math.abs(y);
                            int d = ax + ay + az;
                            if (d >= 7) continue;
                            mut.func_185336_p(y + info.getPos().func_177956_o());
                            BlockState state = info.getState((BlockPos)mut);
                            if (!(state.func_177230_c() instanceof LeavesBlock) || d >= (distance = ((Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a)).intValue())) continue;
                            info.setState((BlockPos)mut, (BlockState)state.func_206870_a((Property)LeavesBlock.field_208494_a, (Comparable)Integer.valueOf(d)));
                        }
                    }
                }
            }
            return info.getState();
        });
        sphere.fillRecursiveIgnore((IWorld)world, pos, IGNORE);
        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, (Block)ModBlocks.TENANEA.bark.get());
        support.forEach(bpos -> {
            BlockState state = world.func_180495_p(bpos);
            if (state.func_196958_f() || state.func_203425_a((Block)ModBlocks.TENANEA_OUTER_LEAVES.get())) {
                int count = ModMathHelper.randRange(3, 8, random);
                mut.func_189533_g((Vector3i)bpos);
                if (world.func_180495_p(mut.func_177984_a()).func_203425_a((Block)ModBlocks.TENANEA_LEAVES.get())) {
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, top);
                    for (int i = 1; i < count; ++i) {
                        mut.func_185336_p(mut.func_177956_o() - 1);
                        if (!world.func_175623_d(mut.func_177977_b())) break;
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, middle);
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, bottom);
                }
            }
        });
    }

    static {
        DIRECTIONS = Direction.values();
        REPLACE = state -> {
            if (state.func_235714_a_(ModTags.END_GROUND)) {
                return true;
            }
            if (state.func_177230_c() == ModBlocks.TENANEA_LEAVES.get()) {
                return true;
            }
            if (state.func_185904_a().equals(Material.field_151585_k)) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
        IGNORE = state -> ModBlocks.TENANEA.isTreeLog((BlockState)state);
        SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
    }
}

