/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import mod.beethoven92.betterendforge.common.block.UmbrellaTreeClusterBlock;
import mod.beethoven92.betterendforge.common.block.UmbrellaTreeMembraneBlock;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.util.SplineHelper;
import mod.beethoven92.betterendforge.common.util.sdf.SDF;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFFlatWave;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFScale3D;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSmoothUnion;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFSubtraction;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFTranslate;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnary;
import mod.beethoven92.betterendforge.common.util.sdf.operator.SDFUnion;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFPrimitive;
import mod.beethoven92.betterendforge.common.util.sdf.primitive.SDFSphere;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class UmbrellaTreeFeature
extends Feature<NoFeatureConfig> {
    private static final Function<BlockState, Boolean> REPLACE;
    private static final List<Vector3f> SPLINE;
    private static final List<Vector3f> ROOT;

    public UmbrellaTreeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        if (!world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.END_GROUND)) {
            return false;
        }
        BlockState wood = ((Block)ModBlocks.UMBRELLA_TREE.bark.get()).func_176223_P();
        BlockState membrane = (BlockState)((Block)ModBlocks.UMBRELLA_TREE_MEMBRANE.get()).func_176223_P().func_206870_a((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(1));
        BlockState center = (BlockState)((Block)ModBlocks.UMBRELLA_TREE_MEMBRANE.get()).func_176223_P().func_206870_a((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(0));
        BlockState fruit = (BlockState)((Block)ModBlocks.UMBRELLA_TREE_CLUSTER.get()).func_176223_P().func_206870_a((Property)UmbrellaTreeClusterBlock.NATURAL, (Comparable)Boolean.valueOf(true));
        float size = ModMathHelper.randRange(10, 20, rand);
        int count = (int)(size * 0.15f);
        float var = (float)Math.PI * 2 / (float)(count * 3);
        float start = ModMathHelper.randRange(0.0f, (float)Math.PI * 2, rand);
        SDF sdf = null;
        ArrayList centers = Lists.newArrayList();
        float scale = 1.0f;
        if (config != null) {
            scale = ModMathHelper.randRange(1.0f, 1.7f, rand);
        }
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2) + ModMathHelper.randRange(0.0f, var, rand) + start;
            List<Vector3f> spline = SplineHelper.copySpline(SPLINE);
            float sizeXZ = (size + ModMathHelper.randRange(0.0f, size * 0.5f, rand)) * 0.7f;
            SplineHelper.scale(spline, sizeXZ, sizeXZ * ModMathHelper.randRange(1.0f, 2.0f, rand), sizeXZ);
            SplineHelper.rotateSpline(spline, angle);
            SplineHelper.offsetParts(spline, rand, 0.5f, 0.0f, 0.5f);
            if (!SplineHelper.canGenerate(spline, pos, (IWorldReader)world, REPLACE)) continue;
            float rScale = (scale - 1.0f) * 0.4f + 1.0f;
            SDF branch = SplineHelper.buildSDF(spline, 1.2f * rScale, 0.8f * rScale, bpos -> wood);
            Vector3f vec = spline.get(spline.size() - 1);
            float radius = (size + ModMathHelper.randRange(0.0f, size * 0.5f, rand)) * 0.4f;
            sdf = sdf == null ? branch : new SDFUnion().setSourceA(sdf).setSourceB(branch);
            SDF mem = this.makeMembrane(world, radius, rand, membrane, center);
            float px = (float)ModMathHelper.floor(vec.func_195899_a()) + 0.5f;
            float py = (float)ModMathHelper.floor(vec.func_195900_b()) + 0.5f;
            float pz = (float)ModMathHelper.floor(vec.func_195902_c()) + 0.5f;
            mem = new SDFTranslate().setTranslate(px, py, pz).setSource(mem);
            sdf = new SDFSmoothUnion().setRadius(2.0f).setSourceA(sdf).setSourceB(mem);
            centers.add(new Center((double)pos.func_177958_n() + (double)(px * scale), (double)pos.func_177956_o() + (double)(py * scale), (double)pos.func_177952_p() + (double)(pz * scale), radius * scale));
            vec = spline.get(0);
        }
        if (sdf == null) {
            return false;
        }
        if (scale > 1.0f) {
            sdf = new SDFScale().setScale(scale).setSource(sdf);
        }
        sdf.setReplaceFunction(REPLACE).addPostProcess(info -> {
            if (ModBlocks.UMBRELLA_TREE.isTreeLog(info.getStateUp()) && ModBlocks.UMBRELLA_TREE.isTreeLog(info.getStateDown())) {
                return ((Block)ModBlocks.UMBRELLA_TREE.log.get()).func_176223_P();
            }
            if (info.getState().equals(membrane)) {
                Center min = (Center)centers.get(0);
                double d = Double.MAX_VALUE;
                BlockPos bpos = info.getPos();
                for (Center c : centers) {
                    double d2 = c.distance(bpos.func_177958_n(), bpos.func_177952_p());
                    if (!(d2 < d)) continue;
                    d = d2;
                    min = c;
                }
                int color = ModMathHelper.floor(d / (double)min.radius * 7.0);
                color = MathHelper.func_76125_a((int)color, (int)1, (int)7);
                return (BlockState)info.getState().func_206870_a((Property)UmbrellaTreeMembraneBlock.COLOR, (Comparable)Integer.valueOf(color));
            }
            return info.getState();
        }).fillRecursive((IWorld)world, pos);
        this.makeRoots(world, pos, (size * 0.5f + 3.0f) * scale, rand, wood);
        for (Center c : centers) {
            if (world.func_180495_p(new BlockPos(c.px, c.py, c.pz)).func_196958_f()) continue;
            count = ModMathHelper.floor(ModMathHelper.randRange(5.0f, 10.0f, rand) * scale);
            float startAngle = rand.nextFloat() * ((float)Math.PI * 2);
            for (int i = 0; i < count; ++i) {
                float angle = (float)i / (float)count * ((float)Math.PI * 2) + startAngle;
                float dist = ModMathHelper.randRange(1.5f, 2.5f, rand) * scale;
                double px = c.px + Math.sin(angle) * (double)dist;
                double pz = c.pz + Math.cos(angle) * (double)dist;
                this.makeFruits(world, px, c.py - 1.0, pz, fruit, scale);
            }
        }
        return true;
    }

    private void makeRoots(ISeedReader world, BlockPos pos, float radius, Random random, BlockState wood) {
        int count = (int)(radius * 1.5f);
        for (int i = 0; i < count; ++i) {
            float angle = (float)i / (float)count * ((float)Math.PI * 2);
            float scale = radius * ModMathHelper.randRange(0.85f, 1.15f, random);
            List<Vector3f> branch = SplineHelper.copySpline(ROOT);
            SplineHelper.rotateSpline(branch, angle);
            SplineHelper.scale(branch, scale);
            Vector3f last = branch.get(branch.size() - 1);
            if (!world.func_180495_p(pos.func_177963_a((double)last.func_195899_a(), (double)last.func_195900_b(), (double)last.func_195902_c())).func_235714_a_(ModTags.GEN_TERRAIN)) continue;
            SplineHelper.fillSplineForce(branch, (IWorld)world, wood, pos, REPLACE);
        }
    }

    private SDF makeMembrane(ISeedReader world, float radius, Random random, BlockState membrane, BlockState center) {
        SDF sphere = new SDFSphere().setRadius(radius).setBlock(membrane);
        SDFUnary sub = new SDFTranslate().setTranslate(0.0f, -4.0f, 0.0f).setSource(sphere);
        sphere = new SDFSubtraction().setSourceA(sphere).setSourceB(sub);
        sphere = new SDFScale3D().setScale(1.0f, 0.5f, 1.0f).setSource(sphere);
        sphere = new SDFTranslate().setTranslate(0.0f, 1.0f - radius * 0.5f, 0.0f).setSource(sphere);
        float angle = random.nextFloat() * ((float)Math.PI * 2);
        int count = (int)ModMathHelper.randRange(radius, radius * 2.0f, random);
        if (count < 5) {
            count = 5;
        }
        sphere = new SDFFlatWave().setAngle(angle).setRaysCount(count).setIntensity(0.6f).setSource(sphere);
        SDFPrimitive cent = new SDFSphere().setRadius(2.5f).setBlock(center);
        sphere = new SDFUnion().setSourceA(sphere).setSourceB(cent);
        return sphere;
    }

    private void makeFruits(ISeedReader world, double px, double py, double pz, BlockState fruit, float scale) {
        BlockPos.Mutable mut = new BlockPos.Mutable().func_189532_c(px, py, pz);
        for (int i = 0; i < 8; ++i) {
            mut.func_189536_c(Direction.DOWN);
            if (!world.func_175623_d((BlockPos)mut)) continue;
            BlockState state = world.func_180495_p(mut.func_177984_a());
            if (!state.func_203425_a((Block)ModBlocks.UMBRELLA_TREE_MEMBRANE.get()) || (Integer)state.func_177229_b((Property)UmbrellaTreeMembraneBlock.COLOR) >= 2) break;
            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)mut, fruit);
            break;
        }
    }

    static {
        SPLINE = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.1f, 0.35f, 0.0f), new Vector3f(0.2f, 0.5f, 0.0f), new Vector3f(0.3f, 0.55f, 0.0f), new Vector3f(0.42f, 0.7f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)});
        ROOT = Lists.newArrayList((Object[])new Vector3f[]{new Vector3f(0.1f, 0.7f, 0.0f), new Vector3f(0.3f, 0.3f, 0.0f), new Vector3f(0.7f, 0.05f, 0.0f), new Vector3f(0.8f, -0.2f, 0.0f)});
        SplineHelper.offset(ROOT, new Vector3f(0.0f, -0.45f, 0.0f));
        REPLACE = state -> {
            if (state.func_235714_a_(ModTags.END_GROUND) || state.func_185904_a().equals(Material.field_151585_k) || state.func_203425_a((Block)ModBlocks.UMBRELLA_TREE_MEMBRANE.get())) {
                return true;
            }
            return state.func_185904_a().func_76222_j();
        };
    }

    private class Center {
        final double px;
        final double py;
        final double pz;
        final float radius;

        Center(double x, double y, double z, float radius) {
            this.px = x;
            this.py = y;
            this.pz = z;
            this.radius = radius;
        }

        double distance(float x, float z) {
            return ModMathHelper.length(this.px - (double)x, this.pz - (double)z);
        }
    }
}

