/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.world.feature.caves;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mod.beethoven92.betterendforge.common.init.ModTags;
import mod.beethoven92.betterendforge.common.util.BlockHelper;
import mod.beethoven92.betterendforge.common.util.ModMathHelper;
import mod.beethoven92.betterendforge.common.world.feature.caves.EndCaveFeature;
import mod.beethoven92.betterendforge.common.world.generator.OpenSimplexNoise;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraftforge.common.Tags;

public class RoundCaveFeature
extends EndCaveFeature {
    @Override
    protected Set<BlockPos> generateCaveBlocks(ISeedReader world, BlockPos center, int radius, Random random) {
        OpenSimplexNoise noise = new OpenSimplexNoise(ModMathHelper.getSeed(534, center.func_177958_n(), center.func_177952_p()));
        int x1 = center.func_177958_n() - radius - 5;
        int z1 = center.func_177952_p() - radius - 5;
        int x2 = center.func_177958_n() + radius + 5;
        int z2 = center.func_177952_p() + radius + 5;
        int y1 = ModMathHelper.floor((double)center.func_177956_o() - (double)(radius + 5) / 1.6);
        int y2 = ModMathHelper.floor((double)center.func_177956_o() + (double)(radius + 5) / 1.6);
        double hr = (double)radius * 0.75;
        double nr = (double)radius * 0.25;
        BlockPos.Mutable bpos = new BlockPos.Mutable();
        HashSet blocks = Sets.newHashSet();
        for (int x = x1; x <= x2; ++x) {
            int xsq = x - center.func_177958_n();
            xsq *= xsq;
            bpos.func_223471_o(x);
            for (int z = z1; z <= z2; ++z) {
                int zsq = z - center.func_177952_p();
                zsq *= zsq;
                bpos.func_223472_q(z);
                for (int y = y1; y <= y2; ++y) {
                    BlockState state;
                    int ysq = y - center.func_177956_o();
                    ysq = (int)((double)ysq * 1.6);
                    ysq *= ysq;
                    bpos.func_185336_p(y);
                    double r = noise.eval((double)x * 0.1, (double)y * 0.1, (double)z * 0.1) * nr + hr;
                    double dist = xsq + ysq + zsq;
                    if (!(dist < r * r) || !this.isReplaceable(state = world.func_180495_p((BlockPos)bpos))) continue;
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                    blocks.add(bpos.func_185334_h());
                    while (state.func_185904_a().equals(Material.field_151584_j)) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                        bpos.func_185336_p(bpos.func_177956_o() + 1);
                        state = world.func_180495_p((BlockPos)bpos);
                    }
                    bpos.func_185336_p(y - 1);
                    while (state.func_185904_a().equals(Material.field_151584_j)) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)bpos, CAVE_AIR);
                        bpos.func_185336_p(bpos.func_177956_o() - 1);
                        state = world.func_180495_p((BlockPos)bpos);
                    }
                }
            }
        }
        return blocks;
    }

    private boolean isReplaceable(BlockState state) {
        return state.func_235714_a_(ModTags.GEN_TERRAIN) || state.func_185904_a().func_76222_j() || state.func_185904_a().equals(Material.field_151585_k) || state.func_185904_a().equals(Material.field_151584_j) || state.func_235714_a_((ITag)Tags.Blocks.ORES) || state.func_235714_a_((ITag)Tags.Blocks.END_STONES);
    }
}

