/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.data.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import mod.beethoven92.betterendforge.common.block.BlockProperties;
import mod.beethoven92.betterendforge.common.block.StalactiteBlock;
import mod.beethoven92.betterendforge.common.block.material.ColoredMaterial;
import mod.beethoven92.betterendforge.common.block.material.MetalMaterial;
import mod.beethoven92.betterendforge.common.block.material.StoneMaterial;
import mod.beethoven92.betterendforge.common.block.material.WoodenMaterial;
import mod.beethoven92.betterendforge.common.block.template.AttachedBlock;
import mod.beethoven92.betterendforge.common.block.template.EndAnvilBlock;
import mod.beethoven92.betterendforge.common.block.template.PedestalBlock;
import mod.beethoven92.betterendforge.common.block.template.PillarBlockTemplate;
import mod.beethoven92.betterendforge.common.init.ModBlocks;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.CraftingTableBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.FurnaceBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.StoneButtonBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class ModBlockStates
extends BlockStateProvider {
    public ModBlockStates(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "betterendforge", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.chandelierBlock((Block)ModBlocks.IRON_CHANDELIER.get());
        this.chandelierBlock((Block)ModBlocks.GOLD_CHANDELIER.get());
        this.furnaceBlock((Block)ModBlocks.END_STONE_FURNACE.get(), "end_stone");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.END_STONE_FURNACE.get(), "end_stone_furnace");
        this.simpleBlock((Block)ModBlocks.MISSING_TILE.get());
        this.makeBlockItemFromExistingModel((Block)ModBlocks.MISSING_TILE.get());
        this.stalactiteBlock((Block)ModBlocks.END_STONE_STALACTITE.get());
        this.stalactiteBlock((Block)ModBlocks.END_STONE_STALACTITE_CAVEMOSS.get());
        this.registerWoodenMaterialBlockStates(ModBlocks.MOSSY_GLOWSHROOM);
        this.registerWoodenMaterialBlockStates(ModBlocks.LACUGROVE);
        this.registerWoodenMaterialBlockStates(ModBlocks.END_LOTUS);
        this.registerWoodenMaterialBlockStates(ModBlocks.PYTHADENDRON);
        this.registerWoodenMaterialBlockStates(ModBlocks.DRAGON_TREE);
        this.registerWoodenMaterialBlockStates(ModBlocks.TENANEA);
        this.registerWoodenMaterialBlockStates(ModBlocks.HELIX_TREE);
        this.registerWoodenMaterialBlockStates(ModBlocks.UMBRELLA_TREE);
        this.registerWoodenMaterialBlockStates(ModBlocks.JELLYSHROOM);
        this.registerWoodenMaterialBlockStates(ModBlocks.LUCERNIA);
        this.registerStoneMaterialBlockStates(ModBlocks.FLAVOLITE);
        this.registerStoneMaterialBlockStates(ModBlocks.VIOLECITE);
        this.registerStoneMaterialBlockStates(ModBlocks.SULPHURIC_ROCK);
        this.registerMetalMaterialBlockStates(ModBlocks.THALLASIUM);
        this.registerMetalMaterialBlockStates(ModBlocks.TERMINITE);
        this.registerColoredMaterialBlockStates(ModBlocks.HYDRALUX_PETAL_BLOCK_COLORED, "block_petal_colored");
        this.bulbLanterns("iron", (Block)ModBlocks.IRON_BULB_LANTERN.get(), ModBlocks.IRON_BULB_LANTERN_COLORED);
        this.registerPedestals();
        this.registerLanterns();
        this.registerFlowerPots();
        this.simpleBlock((Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
        this.makeBlockItemFromExistingModel((Block)ModBlocks.AMARANITA_HYMENOPHORE.get());
        this.simpleBlock((Block)ModBlocks.AMARANITA_CAP.get());
        this.makeBlockItemFromExistingModel((Block)ModBlocks.AMARANITA_CAP.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.DRAGON_BONE_BLOCK.get(), this.modLoc("block/dragon_bone_block_side"), this.modLoc("block/dragon_bone_block_top"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.DRAGON_BONE_BLOCK.get());
        this.stairsBlock((StairsBlock)ModBlocks.DRAGON_BONE_STAIRS.get(), this.modLoc("block/dragon_bone_block"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.DRAGON_BONE_STAIRS.get());
        this.slabBlock((SlabBlock)ModBlocks.DRAGON_BONE_SLAB.get(), this.modLoc("block/dragon_bone_block"), this.modLoc("block/dragon_bone_block"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.DRAGON_BONE_SLAB.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.NEON_CACTUS_BLOCK.get(), this.modLoc("block/neon_cactus_block_side"), this.modLoc("block/neon_cactus_block_top"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.NEON_CACTUS_BLOCK.get());
        this.stairsBlock((StairsBlock)ModBlocks.NEON_CACTUS_BLOCK_STAIRS.get(), this.modLoc("block/neon_cactus_block_side"), this.modLoc("block/neon_cactus_block_top"), this.modLoc("block/neon_cactus_block_top"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.NEON_CACTUS_BLOCK_STAIRS.get());
        this.slabBlock((SlabBlock)ModBlocks.NEON_CACTUS_BLOCK_SLAB.get(), this.modLoc("block/neon_cactus_block"), this.modLoc("block/neon_cactus_block_side"), this.modLoc("block/neon_cactus_block_top"), this.modLoc("block/neon_cactus_block_top"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.NEON_CACTUS_BLOCK_SLAB.get());
        this.simpleBlock((Block)ModBlocks.FILALUX_LANTERN.get());
        this.makeBlockItemFromExistingModel((Block)ModBlocks.FILALUX_LANTERN.get());
    }

    private void registerLanterns() {
        this.lanternBlock((Block)ModBlocks.ANDESITE_LANTERN.get(), "andesite");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.ANDESITE_LANTERN.get(), "andesite_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.DIORITE_LANTERN.get(), "diorite");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.DIORITE_LANTERN.get(), "diorite_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.GRANITE_LANTERN.get(), "granite");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.GRANITE_LANTERN.get(), "granite_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.QUARTZ_LANTERN.get(), "quartz");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.QUARTZ_LANTERN.get(), "quartz_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.PURPUR_LANTERN.get(), "purpur");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.PURPUR_LANTERN.get(), "purpur_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.END_STONE_LANTERN.get(), "end_stone");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.END_STONE_LANTERN.get(), "end_stone_lantern_ceil");
        this.lanternBlock((Block)ModBlocks.BLACKSTONE_LANTERN.get(), "blackstone");
        this.makeBlockItemFromExistingModel((Block)ModBlocks.BLACKSTONE_LANTERN.get(), "blackstone_lantern_ceil");
    }

    private void registerPedestals() {
        this.pedestalBlock((Block)ModBlocks.ANDESITE_PEDESTAL.get(), "andesite", this.mcLoc("block/polished_andesite"), this.mcLoc("block/andesite_pillar"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.ANDESITE_PEDESTAL.get(), "andesite_pedestal_default");
        this.pedestalBlock((Block)ModBlocks.DIORITE_PEDESTAL.get(), "diorite", this.mcLoc("block/polished_diorite"), this.mcLoc("block/diorite_pillar"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.DIORITE_PEDESTAL.get(), "diorite_pedestal_default");
        this.pedestalBlock((Block)ModBlocks.GRANITE_PEDESTAL.get(), "granite", this.mcLoc("block/polished_granite"), this.mcLoc("block/granite_pillar"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.GRANITE_PEDESTAL.get(), "granite_pedestal_default");
        this.pedestalBlock((Block)ModBlocks.PURPUR_PEDESTAL.get(), "purpur", this.mcLoc("block/purpur_block"), this.mcLoc("block/purpur_pillar"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.PURPUR_PEDESTAL.get(), "purpur_pedestal_default");
        this.pedestalBlock((Block)ModBlocks.QUARTZ_PEDESTAL.get(), "quartz", this.mcLoc("block/quartz_block_side"), this.mcLoc("block/quartz_pillar"));
        this.makeBlockItemFromExistingModel((Block)ModBlocks.QUARTZ_PEDESTAL.get(), "quartz_pedestal_default");
    }

    private void registerFlowerPots() {
        ModBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            if (block instanceof FlowerPotBlock) {
                this.flowerPotBlock((Block)block, ((FlowerPotBlock)block).func_220276_d());
            }
        });
    }

    private void registerWoodenMaterialBlockStates(WoodenMaterial material) {
        ResourceLocation planksTexture = this.modLoc("block/" + material.name + "_planks");
        this.simpleBlock((Block)material.planks.get());
        this.makeBlockItemFromExistingModel((Block)material.planks.get());
        this.stairsBlock((StairsBlock)material.stairs.get(), planksTexture);
        this.makeBlockItemFromExistingModel((Block)material.stairs.get());
        this.slabBlock((SlabBlock)material.slab.get(), ((Block)material.planks.get()).getRegistryName(), planksTexture);
        this.makeBlockItemFromExistingModel((Block)material.slab.get());
        this.fenceBlock((FenceBlock)material.fence.get(), planksTexture);
        this.fenceGateBlock((FenceGateBlock)material.gate.get(), planksTexture);
        this.makeBlockItemFromExistingModel((Block)material.gate.get());
        this.doorBlock((DoorBlock)material.door.get(), this.modLoc("block/" + material.name + "_door_bottom"), this.modLoc("block/" + material.name + "_door_top"));
        this.trapdoorBlock((TrapDoorBlock)material.trapdoor.get(), this.modLoc("block/" + material.name + "_trapdoor"), true);
        this.makeBlockItemFromExistingModel((Block)material.trapdoor.get(), "block/" + material.name + "_trapdoor_bottom");
        this.buttonBlock((AbstractButtonBlock)((WoodButtonBlock)material.button.get()), material.name, planksTexture);
        this.pressurePlateBlock((PressurePlateBlock)material.pressurePlate.get(), material.name, planksTexture);
        this.makeBlockItemFromExistingModel((Block)material.pressurePlate.get());
        this.composterBlock((ComposterBlock)material.composter.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.composter.get());
        this.craftingTableBlock((CraftingTableBlock)material.craftingTable.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.craftingTable.get());
        this.ladderBlock((LadderBlock)material.ladder.get(), material.name);
        this.chestBlock((Block)material.chest.get(), material.name);
        this.signBlock((Block)material.sign.get(), material.name);
        this.barrelBlock((Block)material.barrel.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.barrel.get());
        this.shelfBlock((Block)material.shelf.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.shelf.get());
    }

    private void registerStoneMaterialBlockStates(StoneMaterial material) {
        ResourceLocation stoneTexture = this.modLoc("block/" + material.name);
        this.simpleBlock((Block)material.stone.get());
        this.makeBlockItemFromExistingModel((Block)material.stone.get());
        this.simpleBlock((Block)material.polished.get());
        this.makeBlockItemFromExistingModel((Block)material.polished.get());
        this.simpleBlock((Block)material.tiles.get());
        this.makeBlockItemFromExistingModel((Block)material.tiles.get());
        this.axisBlock((PillarBlockTemplate)material.pillar.get(), this.modLoc("block/" + material.name + "_pillar_side"), this.modLoc("block/" + material.name + "_pillar_top"));
        this.makeBlockItemFromExistingModel((Block)material.pillar.get());
        this.stairsBlock((StairsBlock)material.stairs.get(), this.modLoc("block/" + material.name));
        this.makeBlockItemFromExistingModel((Block)material.stairs.get());
        this.slabBlock((SlabBlock)material.slab.get(), ((Block)material.stone.get()).getRegistryName(), this.modLoc("block/" + material.name));
        this.makeBlockItemFromExistingModel((Block)material.slab.get());
        this.wallBlock((WallBlock)material.wall.get(), stoneTexture);
        this.simpleBlock((Block)material.bricks.get());
        this.makeBlockItemFromExistingModel((Block)material.bricks.get());
        this.stairsBlock((StairsBlock)material.brick_stairs.get(), this.modLoc("block/" + material.name + "_bricks"));
        this.makeBlockItemFromExistingModel((Block)material.brick_stairs.get());
        this.slabBlock((SlabBlock)material.brick_slab.get(), ((Block)material.bricks.get()).getRegistryName(), this.modLoc("block/" + material.name + "_bricks"));
        this.makeBlockItemFromExistingModel((Block)material.brick_slab.get());
        this.wallBlock((WallBlock)material.brick_wall.get(), this.modLoc("block/" + material.name + "_bricks"));
        this.buttonBlock((AbstractButtonBlock)((StoneButtonBlock)material.button.get()), material.name, this.modLoc("block/" + material.name));
        this.pressurePlateBlock((PressurePlateBlock)material.pressure_plate.get(), material.name, stoneTexture);
        this.makeBlockItemFromExistingModel((Block)material.pressure_plate.get());
        this.lanternBlock((Block)material.lantern.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.lantern.get(), material.name + "_lantern_ceil");
        this.pedestalBlock((Block)material.pedestal.get(), material.name, this.modLoc("block/" + material.name + "_polished"), this.modLoc("block/" + material.name + "_pillar_side"));
        this.makeBlockItemFromExistingModel((Block)material.pedestal.get(), material.name + "_pedestal_default");
        this.furnaceBlock((Block)material.furnace.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.furnace.get(), material.name + "_furnace");
    }

    private void registerMetalMaterialBlockStates(MetalMaterial material) {
        if (material.hasOre) {
            this.simpleBlock((Block)material.ore.get());
            this.makeBlockItemFromExistingModel((Block)material.ore.get());
        }
        this.simpleBlock((Block)material.block.get());
        this.makeBlockItemFromExistingModel((Block)material.block.get());
        this.simpleBlock((Block)material.tile.get());
        this.makeBlockItemFromExistingModel((Block)material.tile.get());
        this.stairsBlock((StairsBlock)material.stairs.get(), this.modLoc("block/" + material.name + "_tile"));
        this.makeBlockItemFromExistingModel((Block)material.stairs.get());
        this.slabBlock((SlabBlock)material.slab.get(), ((Block)material.tile.get()).getRegistryName(), this.modLoc("block/" + material.name + "_tile"));
        this.makeBlockItemFromExistingModel((Block)material.slab.get());
        this.doorBlock((DoorBlock)material.door.get(), this.modLoc("block/" + material.name + "_door_bottom"), this.modLoc("block/" + material.name + "_door_top"));
        this.trapdoorBlock((TrapDoorBlock)material.trapdoor.get(), this.modLoc("block/" + material.name + "_trapdoor"), true);
        this.makeBlockItemFromExistingModel((Block)material.trapdoor.get(), "block/" + material.name + "_trapdoor_bottom");
        this.pressurePlateBlock((PressurePlateBlock)material.pressure_plate.get(), material.name, this.modLoc("block/" + material.name + "_block"));
        this.makeBlockItemFromExistingModel((Block)material.pressure_plate.get());
        this.chainBlock((Block)material.chain.get());
        this.barsBlock((Block)material.bars.get());
        this.chandelierBlock((Block)material.chandelier.get());
        this.bulbLanterns(material.name, (Block)material.bulb_lantern.get(), material.bulb_lantern_colored);
        this.anvilBlock((Block)material.anvil.get(), material.name);
        this.makeBlockItemFromExistingModel((Block)material.anvil.get(), "block/" + material.name + "_anvil_0");
    }

    private void registerColoredMaterialBlockStates(ColoredMaterial material, String blockModel) {
        for (Block block : material.getBlocks()) {
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/" + blockModel));
            this.simpleBlock(block, (ModelFile)model);
            this.makeBlockItemFromExistingModel(block, "block/" + blockModel);
        }
    }

    private void makeBlockItemFromExistingModel(Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(block.getRegistryName());
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void makeBlockItemFromExistingModel(Block block, String name) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc(name));
        this.simpleBlockItem(block, (ModelFile)model);
    }

    private void buttonBlock(AbstractButtonBlock block, String material, ResourceLocation texture) {
        ModelBuilder button = this.models().singleTexture(material + "_button", this.mcLoc("block/button"), texture);
        ModelBuilder buttonPressed = this.models().singleTexture(material + "_button_pressed", this.mcLoc("block/button_pressed"), texture);
        int angleOffset = 180;
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ModBlockStates.lambda$buttonBlock$1((ModelFile)buttonPressed, (ModelFile)button, angleOffset, arg_0));
    }

    private void pressurePlateBlock(PressurePlateBlock block, String material, ResourceLocation texture) {
        ModelBuilder plate = this.models().singleTexture(material + "_pressure_plate", this.mcLoc("block/pressure_plate_up"), texture);
        ModelBuilder plateDown = this.models().singleTexture(material + "_pressure_plate_down", this.mcLoc("block/pressure_plate_down"), texture);
        this.getVariantBuilder((Block)block).forAllStates(arg_0 -> ModBlockStates.lambda$pressurePlateBlock$2((ModelFile)plateDown, (ModelFile)plate, arg_0));
    }

    private void composterBlock(ComposterBlock block, String material) {
        int i;
        ModelBuilder composter = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_composter", this.mcLoc("composter"))).texture("particle", this.modLoc("block/" + material + "_composter_side"))).texture("top", this.modLoc("block/" + material + "_composter_top"))).texture("bottom", this.modLoc("block/" + material + "_composter_bottom"))).texture("side", this.modLoc("block/" + material + "_composter_side"))).texture("inside", this.modLoc("block/" + material + "_composter_bottom"));
        ModelBuilder composterReady = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_composter_contents_ready", this.mcLoc("composter_contents_ready"))).texture("particle", this.mcLoc("block/composter_compost"))).texture("inside", this.mcLoc("block/composter_ready"));
        ModelFile[] contents = new ModelFile[7];
        for (i = 0; i < contents.length; ++i) {
            contents[i] = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_composter_contents" + (i + 1), this.mcLoc("composter_contents" + (i + 1)))).texture("particle", this.mcLoc("block/composter_compost"))).texture("inside", this.mcLoc("block/composter_compost"));
        }
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)composter).addModel()).end();
        for (i = 0; i < contents.length; ++i) {
            ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile(contents[i]).addModel()).condition((Property)ComposterBlock.field_220298_a, (Comparable[])new Integer[]{i + 1}).end();
        }
        ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder((Block)block).part().modelFile((ModelFile)composterReady).addModel()).condition((Property)ComposterBlock.field_220298_a, (Comparable[])new Integer[]{8}).end();
    }

    private void craftingTableBlock(CraftingTableBlock block, String material) {
        ModelBuilder model = ((BlockModelBuilder)this.models().cube(material + "_crafting_table", this.modLoc("block/" + material + "_crafting_table_bottom"), this.modLoc("block/" + material + "_crafting_table_top"), this.modLoc("block/" + material + "_crafting_table_front"), this.modLoc("block/" + material + "_crafting_table_side"), this.modLoc("block/" + material + "_crafting_table_side"), this.modLoc("block/" + material + "_crafting_table_front"))).texture("particle", this.modLoc("block/" + material + "_crafting_table_top"));
        this.simpleBlock((Block)block, (ModelFile)model);
    }

    private void ladderBlock(LadderBlock block, String material) {
        ModelBuilder ladder = ((BlockModelBuilder)this.models().withExistingParent(material + "_ladder", this.modLoc("block/ladder"))).texture("texture", this.modLoc("block/" + material + "_ladder"));
        this.horizontalBlock((Block)block, (ModelFile)ladder);
    }

    private void chestBlock(Block block, String material) {
        ModelBuilder texture = ((BlockModelBuilder)this.models().getBuilder(material + "_chest")).texture("particle", this.modLoc("block/" + material + "_planks"));
        this.simpleBlock(block, (ModelFile)texture);
    }

    private void signBlock(Block block, String material) {
        ModelBuilder texture = ((BlockModelBuilder)this.models().getBuilder(material + "_sign")).texture("particle", this.modLoc("block/" + material + "_planks"));
        this.simpleBlock(block, (ModelFile)texture);
    }

    private void barrelBlock(Block block, String material) {
        ModelBuilder open = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_barrel_open", this.mcLoc("block/cube_bottom_top"))).texture("top", this.modLoc("block/" + material + "_barrel_top_open"))).texture("bottom", this.modLoc("block/" + material + "_barrel_bottom"))).texture("side", this.modLoc("block/" + material + "_barrel_side"));
        ModelBuilder closed = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_barrel", this.mcLoc("block/cube_bottom_top"))).texture("top", this.modLoc("block/" + material + "_barrel_top"))).texture("bottom", this.modLoc("block/" + material + "_barrel_bottom"))).texture("side", this.modLoc("block/" + material + "_barrel_side"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStates.lambda$barrelBlock$3((ModelFile)open, (ModelFile)closed, arg_0));
    }

    private void shelfBlock(Block block, String material) {
        ModelBuilder texture = this.models().cubeColumn(material + "_bookshelf", this.modLoc("block/" + material + "_bookshelf"), this.modLoc("block/" + material + "_planks"));
        this.simpleBlock(block, (ModelFile)texture);
    }

    private void lanternBlock(Block block, String material) {
        ModelBuilder ceil = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_lantern_ceil", this.modLoc("block/stone_lantern_ceil"))).texture("particle", this.modLoc("block/" + material + "_lantern_side"))).texture("texture", this.modLoc("block/" + material + "_lantern_side"))).texture("top", this.modLoc("block/" + material + "_lantern_top"))).texture("crystal", this.modLoc("block/aurora_crystal"))).texture("bottom", this.modLoc("block/" + material + "_lantern_bottom"));
        ModelBuilder floor = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_lantern_floor", this.modLoc("block/stone_lantern_floor"))).texture("particle", this.modLoc("block/" + material + "_lantern_side"))).texture("texture", this.modLoc("block/" + material + "_lantern_side"))).texture("top", this.modLoc("block/" + material + "_lantern_top"))).texture("crystal", this.modLoc("block/aurora_crystal"))).texture("bottom", this.modLoc("block/" + material + "_lantern_bottom"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStates.lambda$lanternBlock$4((ModelFile)floor, (ModelFile)ceil, arg_0));
    }

    private void pedestalBlock(Block block, String material, ResourceLocation polished, ResourceLocation pillar) {
        HashMap<BlockProperties.PedestalState, ModelBuilder> models = new HashMap<BlockProperties.PedestalState, ModelBuilder>();
        models.put(BlockProperties.PedestalState.COLUMN_TOP, ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_column_top", this.modLoc("block/pedestal_column_top"))).texture("base", polished)).texture("pillar", pillar));
        models.put(BlockProperties.PedestalState.COLUMN, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_column", this.modLoc("block/pedestal_column"))).texture("base", polished)).texture("pillar", pillar)).texture("bottom", polished));
        models.put(BlockProperties.PedestalState.PEDESTAL_TOP, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_top", this.modLoc("block/pedestal_top"))).texture("top", polished)).texture("base", polished)).texture("pillar", pillar));
        models.put(BlockProperties.PedestalState.BOTTOM, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_bottom", this.modLoc("block/pedestal_bottom"))).texture("base", polished)).texture("pillar", pillar)).texture("bottom", polished));
        models.put(BlockProperties.PedestalState.PILLAR, ((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_pillar", this.modLoc("block/pedestal_pillar"))).texture("pillar", pillar));
        models.put(BlockProperties.PedestalState.DEFAULT, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_pedestal_default", this.modLoc("block/pedestal_default"))).texture("top", polished)).texture("base", polished)).texture("pillar", pillar)).texture("bottom", polished));
        this.getVariantBuilder(block).forAllStates(state -> {
            BlockProperties.PedestalState pedestalState = (BlockProperties.PedestalState)((Object)((Object)state.func_177229_b(PedestalBlock.STATE)));
            return ConfiguredModel.builder().modelFile((ModelFile)models.get((Object)pedestalState)).build();
        });
    }

    private void bulbLanterns(String material, Block bulbLantern, ColoredMaterial bulbLanternColored) {
        ModelBuilder ceil = ((BlockModelBuilder)this.models().withExistingParent(material + "_bulb_lantern_colored_ceil", this.modLoc("bulb_lantern_colored_ceil"))).texture("metal", this.modLoc("block/" + material + "_bulb_vine_lantern_metal"));
        ModelBuilder floor = ((BlockModelBuilder)this.models().withExistingParent(material + "_bulb_lantern_colored_floor", this.modLoc("bulb_lantern_colored_floor"))).texture("metal", this.modLoc("block/" + material + "_bulb_vine_lantern_metal"));
        ArrayList<Block> lanterns = new ArrayList<Block>();
        lanterns.add(bulbLantern);
        Collections.addAll(lanterns, bulbLanternColored.getBlocks());
        for (Block lantern : lanterns) {
            this.getVariantBuilder(lantern).forAllStates(arg_0 -> ModBlockStates.lambda$bulbLanterns$6((ModelFile)floor, (ModelFile)ceil, arg_0));
            this.makeBlockItemFromExistingModel(lantern, material + "_bulb_lantern_colored_ceil");
        }
    }

    private void flowerPotBlock(Block pot_block, Block plant) {
        ModelBuilder pot = ((BlockModelBuilder)this.models().withExistingParent("potted_" + plant.getRegistryName().func_110623_a(), this.mcLoc("block/flower_pot_cross"))).texture("plant", this.modLoc("block/" + plant.getRegistryName().func_110623_a()));
        this.simpleBlock(pot_block, (ModelFile)pot);
    }

    private void chainBlock(Block chain_block) {
        ModelBuilder chain = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(chain_block.getRegistryName().func_110623_a(), this.mcLoc("block/chain"))).texture("particle", this.modLoc("block/" + chain_block.getRegistryName().func_110623_a()))).texture("all", this.modLoc("block/" + chain_block.getRegistryName().func_110623_a()));
        this.axisBlock((RotatedPillarBlock)chain_block, (ModelFile)chain, (ModelFile)chain);
    }

    private void barsBlock(Block barsBlock) {
        ModelBuilder post = ((BlockModelBuilder)this.models().withExistingParent(barsBlock.getRegistryName().func_110623_a() + "_post", this.modLoc("metal_bars_post"))).texture("top", this.modLoc("block/" + barsBlock.getRegistryName().func_110623_a() + "_top"));
        ModelBuilder side = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(barsBlock.getRegistryName().func_110623_a() + "_side", this.modLoc("metal_bars_side"))).texture("top", this.modLoc("block/" + barsBlock.getRegistryName().func_110623_a() + "_top"))).texture("side", this.modLoc("block/" + barsBlock.getRegistryName().func_110623_a()));
        MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(barsBlock).part().modelFile((ModelFile)post).addModel()).condition((Property)SixWayBlock.field_196491_B.get(Direction.NORTH), (Comparable[])new Boolean[]{false}).condition((Property)SixWayBlock.field_196491_B.get(Direction.SOUTH), (Comparable[])new Boolean[]{false}).condition((Property)SixWayBlock.field_196491_B.get(Direction.EAST), (Comparable[])new Boolean[]{false}).condition((Property)SixWayBlock.field_196491_B.get(Direction.WEST), (Comparable[])new Boolean[]{false}).end();
        this.fourWayMultipart(builder, (ModelFile)side);
    }

    private void chandelierBlock(Block chandelier) {
        ModelBuilder ceil = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(chandelier.getRegistryName().func_110623_a() + "_ceil", this.modLoc("chandelier_ceil"))).texture("rod", this.modLoc("block/" + chandelier.getRegistryName().func_110623_a() + "_floor"))).texture("texture", this.modLoc("block/" + chandelier.getRegistryName().func_110623_a() + "_ceil"));
        ModelBuilder wall = ((BlockModelBuilder)this.models().withExistingParent(chandelier.getRegistryName().func_110623_a() + "_wall", this.modLoc("chandelier_wall"))).texture("texture", this.modLoc("block/" + chandelier.getRegistryName().func_110623_a() + "_wall"));
        ModelBuilder floor = ((BlockModelBuilder)this.models().withExistingParent(chandelier.getRegistryName().func_110623_a() + "_floor", this.modLoc("chandelier_floor"))).texture("texture", this.modLoc("block/" + chandelier.getRegistryName().func_110623_a() + "_floor"));
        this.getVariantBuilder(chandelier).forAllStates(arg_0 -> ModBlockStates.lambda$chandelierBlock$7((ModelFile)floor, (ModelFile)ceil, (ModelFile)wall, arg_0));
    }

    private void anvilBlock(Block block, String material) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int destruction = (Integer)state.func_177229_b((Property)EndAnvilBlock.DESTRUCTION);
            ModelBuilder anvil = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_anvil_" + destruction, this.modLoc("block/anvil"))).texture("front", this.modLoc("block/" + material + "_anvil_front"))).texture("bottom", this.modLoc("block/" + material + "_anvil_bottom"))).texture("back", this.modLoc("block/" + material + "_anvil_back"))).texture("panel", this.modLoc("block/" + material + "_anvil_panel"))).texture("top", this.modLoc("block/" + material + "_anvil_top_" + destruction));
            Direction dir = (Direction)state.func_177229_b((Property)AnvilBlock.field_176506_a);
            int x = 0;
            int y = 0;
            switch (dir) {
                case EAST: {
                    y = 270;
                    break;
                }
                case NORTH: {
                    y = 180;
                    break;
                }
                case SOUTH: {
                    break;
                }
                case WEST: {
                    y = 90;
                    break;
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)anvil).rotationX(x).rotationY(y).build();
        });
    }

    private void furnaceBlock(Block block, String material) {
        ModelBuilder furnace = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_furnace", this.mcLoc("block/orientable_with_bottom"))).texture("top", this.modLoc("block/" + material + "_furnace_top"))).texture("front", this.modLoc("block/" + material + "_furnace_front"))).texture("side", this.modLoc("block/" + material + "_furnace_side"))).texture("bottom", this.modLoc("block/" + material + "_furnace_top"));
        ModelBuilder furnaceOn = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(material + "_furnace_on", this.modLoc("block/furnace_glow"))).texture("top", this.modLoc("block/" + material + "_furnace_top"))).texture("front", this.modLoc("block/" + material + "_furnace_front_on"))).texture("side", this.modLoc("block/" + material + "_furnace_side"))).texture("glow", this.modLoc("block/" + material + "_furnace_glow"));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStates.lambda$furnaceBlock$9((ModelFile)furnaceOn, (ModelFile)furnace, arg_0));
    }

    private void stalactiteBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean isFloor = (Boolean)state.func_177229_b((Property)StalactiteBlock.IS_FLOOR);
            int size = (Integer)state.func_177229_b((Property)StalactiteBlock.SIZE);
            ModelBuilder currentSize = ((BlockModelBuilder)this.models().withExistingParent(block.getRegistryName().func_110623_a() + "_" + size, this.mcLoc("block/cross"))).texture("cross", this.modLoc("block/" + block.getRegistryName().func_110623_a() + "_" + size));
            return ConfiguredModel.builder().modelFile((ModelFile)currentSize).rotationX(isFloor ? 0 : 180).build();
        });
    }

    private static /* synthetic */ ConfiguredModel[] lambda$furnaceBlock$9(ModelFile furnaceOn, ModelFile furnace, BlockState state) {
        boolean isLit = (Boolean)state.func_177229_b((Property)FurnaceBlock.field_220091_b);
        Direction dir = (Direction)state.func_177229_b((Property)FurnaceBlock.field_220090_a);
        int x = 0;
        int y = 0;
        switch (dir) {
            case EAST: {
                y = 90;
                break;
            }
            case NORTH: {
                break;
            }
            case SOUTH: {
                y = 180;
                break;
            }
            case WEST: {
                y = 270;
                break;
            }
        }
        return ConfiguredModel.builder().modelFile(isLit ? furnaceOn : furnace).rotationX(x).rotationY(y).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$chandelierBlock$7(ModelFile floor, ModelFile ceil, ModelFile wall, BlockState state) {
        Direction dir = (Direction)state.func_177229_b((Property)AttachedBlock.FACING);
        int y = 0;
        switch (dir) {
            case DOWN: {
                break;
            }
            case EAST: {
                y = 270;
                break;
            }
            case NORTH: {
                y = 180;
                break;
            }
            case SOUTH: {
                break;
            }
            case UP: {
                break;
            }
            case WEST: {
                y = 90;
            }
        }
        return ConfiguredModel.builder().modelFile(dir == Direction.UP ? floor : (dir == Direction.DOWN ? ceil : wall)).rotationY(y).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$bulbLanterns$6(ModelFile floor, ModelFile ceil, BlockState state) {
        boolean isFloor = (Boolean)state.func_177229_b((Property)LanternBlock.field_220278_a) == false;
        return ConfiguredModel.builder().modelFile(isFloor ? floor : ceil).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lanternBlock$4(ModelFile floor, ModelFile ceil, BlockState state) {
        boolean isFloor = (Boolean)state.func_177229_b((Property)LanternBlock.field_220278_a) == false;
        return ConfiguredModel.builder().modelFile(isFloor ? floor : ceil).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$barrelBlock$3(ModelFile open, ModelFile closed, BlockState state) {
        boolean opened = (Boolean)state.func_177229_b((Property)BarrelBlock.field_220093_b);
        Direction dir = (Direction)state.func_177229_b((Property)BarrelBlock.field_220092_a);
        int x = 0;
        int y = 0;
        switch (dir) {
            case DOWN: {
                x = 180;
                break;
            }
            case EAST: {
                x = 90;
                y = 90;
                break;
            }
            case NORTH: {
                x = 90;
                break;
            }
            case SOUTH: {
                x = 90;
                y = 180;
                break;
            }
            case UP: {
                break;
            }
            case WEST: {
                x = 90;
                y = 270;
            }
        }
        return ConfiguredModel.builder().modelFile(opened ? open : closed).rotationX(x).rotationY(y).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$pressurePlateBlock$2(ModelFile plateDown, ModelFile plate, BlockState state) {
        boolean powered = (Boolean)state.func_177229_b((Property)PressurePlateBlock.field_176580_a);
        return ConfiguredModel.builder().modelFile(powered ? plateDown : plate).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$buttonBlock$1(ModelFile buttonPressed, ModelFile button, int angleOffset, BlockState state) {
        boolean powered = (Boolean)state.func_177229_b((Property)WoodButtonBlock.field_176584_b);
        return ConfiguredModel.builder().modelFile(powered ? buttonPressed : button).rotationX(((AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K)).ordinal() * 90).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + angleOffset + (state.func_177229_b((Property)BlockStateProperties.field_208158_K) == AttachFace.CEILING ? 180 : 0)) % 360).build();
    }
}

