/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.api;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.ReferenceBuildingConfigScreen;
import me.shedaniel.clothconfig2.api.ReferenceProvider;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.clothconfig2.api.ValueHolder;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractConfigEntry<T>
extends DynamicElementListWidget.ElementEntry<AbstractConfigEntry<T>>
implements ReferenceProvider<T>,
ValueHolder<T> {
    private AbstractConfigScreen screen;
    private Supplier<Optional<ITextComponent>> errorSupplier;
    @Nullable
    private List<ReferenceProvider<?>> referencableEntries = null;
    @Nullable
    protected Consumer<T> saveCallback;
    private int cacheFieldNameHash = -1;
    private List<String> cachedTags = null;
    private Iterable<String> additionalSearchTags = null;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public final void setReferencableEntries(@Nullable List<AbstractConfigEntry<?>> referencableEntries) {
        this.setReferenceProviderEntries(referencableEntries.stream().map(AbstractConfigEntry::provideReferenceEntry).collect(Collectors.toList()));
    }

    public final void setReferenceProviderEntries(@Nullable List<ReferenceProvider<?>> referencableEntries) {
        this.referencableEntries = referencableEntries;
    }

    public void requestReferenceRebuilding() {
        AbstractConfigScreen configScreen = this.getConfigScreen();
        if (configScreen instanceof ReferenceBuildingConfigScreen) {
            ((ReferenceBuildingConfigScreen)((Object)configScreen)).requestReferenceRebuilding();
        }
    }

    @Override
    @NotNull
    public AbstractConfigEntry<T> provideReferenceEntry() {
        return this;
    }

    @Deprecated
    @Nullable
    @ApiStatus.Internal
    @ApiStatus.ScheduledForRemoval
    public final List<AbstractConfigEntry<?>> getReferencableEntries() {
        return this.referencableEntries.stream().map(ReferenceProvider::provideReferenceEntry).collect(Collectors.toList());
    }

    @Nullable
    @ApiStatus.Internal
    public final List<ReferenceProvider<?>> getReferenceProviderEntries() {
        return this.referencableEntries;
    }

    public abstract boolean isRequiresRestart();

    public abstract void setRequiresRestart(boolean var1);

    public abstract ITextComponent getFieldName();

    public ITextComponent getDisplayedFieldName() {
        IFormattableTextComponent text = this.getFieldName().func_230532_e_();
        boolean hasError = this.getConfigError().isPresent();
        boolean isEdited = this.isEdited();
        if (hasError) {
            text = text.func_240699_a_(TextFormatting.RED);
        }
        if (isEdited) {
            text = text.func_240699_a_(TextFormatting.ITALIC);
        }
        if (!hasError && !isEdited) {
            text = text.func_240699_a_(TextFormatting.GRAY);
        }
        if (!this.isEnabled()) {
            text = text.func_240699_a_(TextFormatting.DARK_GRAY);
        }
        return text;
    }

    public Iterator<String> getSearchTags() {
        String s = this.getFieldName().getString();
        if (s.isEmpty()) {
            this.cacheFieldNameHash = -1;
            this.cachedTags = null;
            return ((Iterable)MoreObjects.firstNonNull(this.additionalSearchTags, Collections.emptyList())).iterator();
        }
        if (s.hashCode() != this.cacheFieldNameHash) {
            this.cacheFieldNameHash = s.hashCode();
            this.cachedTags = Lists.newArrayList((Object[])s.split(" "));
        }
        return Iterators.concat(this.cachedTags.iterator(), ((Iterable)MoreObjects.firstNonNull(this.additionalSearchTags, Collections.emptyList())).iterator());
    }

    public void appendSearchTags(Iterable<String> tags) {
        this.additionalSearchTags = this.additionalSearchTags == null ? tags : Iterables.concat(this.additionalSearchTags, tags);
    }

    public final Optional<ITextComponent> getConfigError() {
        if (this.errorSupplier != null && this.errorSupplier.get().isPresent()) {
            return this.errorSupplier.get();
        }
        return this.getError();
    }

    public void lateRender(MatrixStack matrices, int mouseX, int mouseY, float delta) {
    }

    public void setErrorSupplier(Supplier<Optional<ITextComponent>> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    public Optional<ITextComponent> getError() {
        return Optional.empty();
    }

    public abstract Optional<T> getDefaultValue();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public final ClothConfigScreen getScreen() {
        if (this.screen instanceof ClothConfigScreen) {
            return (ClothConfigScreen)this.screen;
        }
        return null;
    }

    @Nullable
    public final AbstractConfigScreen getConfigScreen() {
        return this.screen;
    }

    public final void addTooltip(@NotNull Tooltip tooltip) {
        this.screen.addTooltip(tooltip);
    }

    protected IReorderingProcessor[] wrapLinesToScreen(ITextComponent[] lines) {
        return this.wrapLines(lines, this.screen.field_230708_k_);
    }

    protected IReorderingProcessor[] wrapLines(ITextComponent[] lines, int width) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        return (IReorderingProcessor[])Arrays.stream(lines).map(line -> font.func_238425_b_((ITextProperties)line, width)).flatMap(Collection::stream).toArray(IReorderingProcessor[]::new);
    }

    public void updateSelected(boolean isSelected) {
    }

    @ApiStatus.Internal
    public final void setScreen(AbstractConfigScreen screen) {
        this.screen = screen;
    }

    public void save() {
        if (this.saveCallback != null) {
            this.saveCallback.accept(this.getValue());
        }
    }

    public boolean isEdited() {
        return this.getConfigError().isPresent();
    }

    @Override
    public int getItemHeight() {
        return 24;
    }

    public int getInitialReferenceOffset() {
        return 0;
    }
}

