/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.ApiStatus;

public abstract class AbstractNumberListEntry<T>
extends TextFieldListEntry<T> {
    private static final Function<String, String> stripCharacters = s -> {
        char[] chars;
        StringBuilder builder = new StringBuilder();
        for (char c : chars = s.toCharArray()) {
            if (!Character.isDigit(c) && c != '-' && c != '.') continue;
            builder.append(c);
        }
        return builder.toString();
    };
    protected T minimum;
    protected T maximum;

    @Deprecated
    @ApiStatus.Internal
    protected AbstractNumberListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue) {
        super(fieldName, original, resetButtonKey, defaultValue);
        this.applyDefaultRange();
    }

    @Deprecated
    @ApiStatus.Internal
    protected AbstractNumberListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        super(fieldName, original, resetButtonKey, defaultValue, tooltipSupplier);
        this.applyDefaultRange();
    }

    @Deprecated
    @ApiStatus.Internal
    protected AbstractNumberListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, original, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.applyDefaultRange();
    }

    protected abstract Map.Entry<T, T> getDefaultRange();

    private void applyDefaultRange() {
        Map.Entry<T, T> range = this.getDefaultRange();
        if (range != null) {
            this.minimum = range.getKey();
            this.maximum = range.getValue();
        }
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }
}

