/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.math.Point;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    @Nullable
    private Supplier<Optional<ITextComponent[]>> tooltipSupplier;

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(ITextComponent fieldName, @Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, requiresRestart);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight)) {
            this.getTooltip(mouseX, mouseY).map(lines -> Tooltip.of(new Point(mouseX, mouseY), this.wrapLinesToScreen((ITextComponent[])lines))).ifPresent(this::addTooltip);
        }
    }

    public Optional<ITextComponent[]> getTooltip() {
        Stream tooltipStream = (this.tooltipSupplier == null ? Stream.empty() : Stream.of(this.tooltipSupplier)).map(Supplier::get).flatMap(opt -> !opt.isPresent() ? Stream.empty() : Stream.of((ITextComponent[])opt.get()));
        @Nullable TranslationTextComponent disabled = this.isEnabled() ? null : new TranslationTextComponent("text.cloth-config.disabled_tooltip");
        ITextComponent[] lines = (ITextComponent[])Stream.concat(tooltipStream, disabled == null ? Stream.empty() : Stream.of(disabled)).toArray(ITextComponent[]::new);
        return lines.length < 1 ? Optional.empty() : Optional.of(lines);
    }

    public Optional<ITextComponent[]> getTooltip(int mouseX, int mouseY) {
        return this.getTooltip();
    }

    @Nullable
    public Supplier<Optional<ITextComponent[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }
}

