/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BooleanToggleBuilder
extends AbstractFieldBuilder<Boolean, BooleanListEntry, BooleanToggleBuilder> {
    @Nullable
    private Function<Boolean, ITextComponent> yesNoTextSupplier = null;

    public BooleanToggleBuilder(ITextComponent resetButtonKey, ITextComponent fieldNameKey, boolean value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    @Override
    public BooleanToggleBuilder setErrorSupplier(Function<Boolean, Optional<ITextComponent>> errorSupplier) {
        return (BooleanToggleBuilder)super.setErrorSupplier(errorSupplier);
    }

    @Override
    public BooleanToggleBuilder requireRestart() {
        return (BooleanToggleBuilder)super.requireRestart();
    }

    @Override
    public BooleanToggleBuilder setSaveConsumer(Consumer<Boolean> saveConsumer) {
        return (BooleanToggleBuilder)super.setSaveConsumer(saveConsumer);
    }

    @Override
    public BooleanToggleBuilder setDefaultValue(Supplier<Boolean> defaultValue) {
        return (BooleanToggleBuilder)super.setDefaultValue(defaultValue);
    }

    @Override
    public BooleanToggleBuilder setDefaultValue(boolean defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    @Override
    public BooleanToggleBuilder setTooltipSupplier(Function<Boolean, Optional<ITextComponent[]>> tooltipSupplier) {
        return (BooleanToggleBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public BooleanToggleBuilder setTooltipSupplier(Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        return (BooleanToggleBuilder)super.setTooltipSupplier(tooltipSupplier);
    }

    @Override
    public BooleanToggleBuilder setTooltip(Optional<ITextComponent[]> tooltip) {
        return (BooleanToggleBuilder)super.setTooltip(tooltip);
    }

    @Override
    public BooleanToggleBuilder setTooltip(ITextComponent ... tooltip) {
        return (BooleanToggleBuilder)super.setTooltip(tooltip);
    }

    @Nullable
    public Function<Boolean, ITextComponent> getYesNoTextSupplier() {
        return this.yesNoTextSupplier;
    }

    public BooleanToggleBuilder setYesNoTextSupplier(@Nullable Function<Boolean, ITextComponent> yesNoTextSupplier) {
        this.yesNoTextSupplier = yesNoTextSupplier;
        return this;
    }

    @Override
    @NotNull
    public BooleanListEntry build() {
        BooleanListEntry entry = new BooleanListEntry(this.getFieldNameKey(), (Boolean)this.value, this.getResetButtonKey(), this.defaultValue, this.getSaveConsumer(), null, this.isRequireRestart()){

            @Override
            public ITextComponent getYesNoText(boolean bool) {
                if (BooleanToggleBuilder.this.yesNoTextSupplier == null) {
                    return super.getYesNoText(bool);
                }
                return (ITextComponent)BooleanToggleBuilder.this.yesNoTextSupplier.apply(bool);
            }
        };
        entry.setTooltipSupplier(() -> this.getTooltipSupplier().apply(entry.getValue()));
        if (this.errorSupplier != null) {
            entry.setErrorSupplier(() -> (Optional)this.errorSupplier.apply(entry.getValue()));
        }
        return this.finishBuilding(entry);
    }
}

