/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client;

import dev.toma.configuration.client.ClientErrors;
import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.screen.ArrayConfigScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.widget.BooleanWidget;
import dev.toma.configuration.client.widget.ColorWidget;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.client.widget.EnumWidget;
import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.value.BooleanArrayValue;
import dev.toma.configuration.config.value.BooleanValue;
import dev.toma.configuration.config.value.CharValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.DecimalValue;
import dev.toma.configuration.config.value.DoubleArrayValue;
import dev.toma.configuration.config.value.DoubleValue;
import dev.toma.configuration.config.value.EnumArrayValue;
import dev.toma.configuration.config.value.EnumValue;
import dev.toma.configuration.config.value.FloatArrayValue;
import dev.toma.configuration.config.value.FloatValue;
import dev.toma.configuration.config.value.IntArrayValue;
import dev.toma.configuration.config.value.IntValue;
import dev.toma.configuration.config.value.IntegerValue;
import dev.toma.configuration.config.value.LongArrayValue;
import dev.toma.configuration.config.value.LongValue;
import dev.toma.configuration.config.value.ObjectValue;
import dev.toma.configuration.config.value.StringArrayValue;
import dev.toma.configuration.config.value.StringValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

@FunctionalInterface
public interface DisplayAdapter {
    public void placeWidgets(ConfigValue<?> var1, Field var2, WidgetAdder var3);

    public static DisplayAdapter booleanValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> new BooleanWidget(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, (BooleanValue)value));
    }

    public static DisplayAdapter characterValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            TextFieldWidget widget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
            CharValue charValue = (CharValue)value;
            char character = ((Character)charValue.get()).charValue();
            widget.func_146180_a(String.valueOf(character));
            widget.func_200675_a(str -> str.length() <= 1);
            widget.func_212954_a(str -> {
                if (str.length() > 0) {
                    container.setOkStatus();
                    char toSet = str.charAt(0);
                    charValue.setWithValidationHandler(Character.valueOf(toSet), container);
                } else {
                    container.setValidationResult(ValidationResult.error(ClientErrors.CHAR_VALUE_EMPTY));
                }
            });
            ConfigUtils.adjustCharacterLimit(field, widget);
            return widget;
        });
    }

    public static DisplayAdapter integerValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            TextFieldWidget tfw = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
            IntValue intValue = (IntValue)value;
            int num = (Integer)intValue.get();
            tfw.func_146180_a(String.valueOf(num));
            tfw.func_200675_a(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.INTEGER_CHARS));
            tfw.func_212954_a(str -> {
                int n;
                if (!ConfigUtils.INTEGER_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                IntegerValue.Range range = intValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                intValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter longValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            TextFieldWidget tfw = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
            LongValue longValue = (LongValue)value;
            long num = (Long)longValue.get();
            tfw.func_146180_a(String.valueOf(num));
            tfw.func_200675_a(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.INTEGER_CHARS));
            tfw.func_212954_a(str -> {
                long n;
                if (!ConfigUtils.INTEGER_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Long.parseLong(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                IntegerValue.Range range = longValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                longValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter floatValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            TextFieldWidget tfw = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
            FloatValue floatValue = (FloatValue)value;
            DecimalFormat format = ConfigUtils.getDecimalFormat(field);
            float number = ((Float)floatValue.get()).floatValue();
            tfw.func_146180_a(format != null ? format.format(number) : String.valueOf(number));
            tfw.func_200675_a(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.DECIMAL_CHARS));
            tfw.func_212954_a(str -> {
                float n;
                if (!ConfigUtils.DECIMAL_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Float.parseFloat(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                DecimalValue.Range range = floatValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                floatValue.setWithValidationHandler(Float.valueOf(n), container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter doubleValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            TextFieldWidget tfw = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
            DoubleValue doubleValue = (DoubleValue)value;
            DecimalFormat format = ConfigUtils.getDecimalFormat(field);
            double number = (Double)doubleValue.get();
            tfw.func_146180_a(format != null ? format.format(number) : String.valueOf(number));
            tfw.func_200675_a(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.DECIMAL_CHARS));
            tfw.func_212954_a(str -> {
                double n;
                if (!ConfigUtils.DECIMAL_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Double.parseDouble(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                DecimalValue.Range range = doubleValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                doubleValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter stringValue() {
        return (value, field, container) -> {
            Configurable.Gui.ColorValue colorValue = field.getAnnotation(Configurable.Gui.ColorValue.class);
            StringValue strValue = (StringValue)value;
            TextFieldWidget widget = container.addConfigWidget((x, y, width, height, configId) -> {
                TextFieldWidget tfw = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, StringTextComponent.field_240750_d_);
                String val = (String)strValue.get();
                tfw.func_146180_a(val);
                tfw.func_212954_a(str -> {
                    Pattern pattern = strValue.getPattern();
                    if (pattern != null && !pattern.matcher((CharSequence)str).matches()) {
                        String errDescriptor = strValue.getErrorDescriptor();
                        TranslationTextComponent error = errDescriptor != null ? new TranslationTextComponent(errDescriptor, new Object[]{str, pattern}) : ClientErrors.invalidText(str, pattern);
                        container.setValidationResult(ValidationResult.error((IFormattableTextComponent)error));
                        return;
                    }
                    container.setOkStatus();
                    strValue.setWithValidationHandler(str, container);
                });
                ConfigUtils.adjustCharacterLimit(field, tfw);
                return tfw;
            });
            if (colorValue != null) {
                container.addConfigWidget((x, y, width, height, configId) -> {
                    int left = DisplayAdapter.getValueX(x, width) - 25;
                    ColorWidget.GetSet<String> provider = ColorWidget.GetSet.of(() -> ((TextFieldWidget)widget).func_146179_b(), arg_0 -> ((TextFieldWidget)widget).func_146180_a(arg_0));
                    Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
                    return new ColorWidget(left, y, 20, 20, colorValue, provider, currentScreen);
                });
            }
        };
    }

    public static DisplayAdapter booleanArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            BooleanArrayValue arrayValue = (BooleanArrayValue)value;
            BiConsumer<Boolean, Integer> setCallback = (val, i) -> {
                boolean[] arr = (boolean[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((boolean[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    return new BooleanValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Boolean.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    boolean[] expanded = new boolean[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = false;
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new boolean[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter integerArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            IntArrayValue arrayValue = (IntArrayValue)value;
            BiConsumer<Integer, Integer> setCallback = (val, i) -> {
                int[] arr = (int[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((int[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    int[] arr = (int[])arrayValue.get();
                    return new IntValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Integer.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    int[] arr = (int[])arrayValue.get();
                    int[] expanded = new int[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max((int)arrayValue.getRange().min(), 0);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    int[] arr = (int[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new int[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter longArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            LongArrayValue arrayValue = (LongArrayValue)value;
            BiConsumer<Long, Integer> setCallback = (val, i) -> {
                long[] arr = (long[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((long[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    long[] arr = (long[])arrayValue.get();
                    return new LongValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Long.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    long[] arr = (long[])arrayValue.get();
                    long[] expanded = new long[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max(arrayValue.getRange().min(), 0L);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    long[] arr = (long[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new long[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter floatArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            FloatArrayValue arrayValue = (FloatArrayValue)value;
            BiConsumer<Float, Integer> setCallback = (val, i) -> {
                float[] arr = (float[])arrayValue.get();
                arr[i.intValue()] = val.floatValue();
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((float[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    float[] arr = (float[])arrayValue.get();
                    return new FloatValue(ValueData.of(id, Float.valueOf(arr[i]), ArrayConfigScreen.callbackCtx(field, Float.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    float[] arr = (float[])arrayValue.get();
                    float[] expanded = new float[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max((float)arrayValue.getRange().min(), 0.0f);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    float[] arr = (float[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new float[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter doubleArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            DoubleArrayValue arrayValue = (DoubleArrayValue)value;
            BiConsumer<Double, Integer> setCallback = (val, i) -> {
                double[] arr = (double[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((double[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    double[] arr = (double[])arrayValue.get();
                    return new DoubleValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Double.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    double[] arr = (double[])arrayValue.get();
                    double[] expanded = new double[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max(arrayValue.getRange().min(), 0.0);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    double[] arr = (double[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new double[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter stringArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            StringArrayValue arrayValue = (StringArrayValue)value;
            BiConsumer<String, Integer> setCallback = (val, i) -> {
                String[] arr = (String[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((String[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    String[] arr = (String[])arrayValue.get();
                    return new StringValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, String.class, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    String[] arr = (String[])arrayValue.get();
                    String[] expanded = new String[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = arrayValue.getDefaultElementValue();
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    String[] arr = (String[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new String[arr.length - 1]));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter enumValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> new EnumWidget(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, (EnumValue)value));
    }

    public static <E extends Enum<E>> DisplayAdapter enumArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            EnumArrayValue enumArray = (EnumArrayValue)value;
            BiConsumer<Enum, Integer> setCallback = (val, i) -> {
                Enum[] arr = (Enum[])enumArray.get();
                arr[i.intValue()] = val;
                enumArray.set(arr);
            };
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen usedScreen = client.field_71462_r;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, enumArray, usedScreen);
                screen.fetchSize(() -> ((Enum[])enumArray.get()).length);
                screen.valueFactory((id, i) -> {
                    Enum[] arr = (Enum[])enumArray.get();
                    return new EnumValue<Enum>(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, enumArray.getValueType().getComponentType(), setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    Enum[] arr = (Enum[])enumArray.get();
                    Class<?> type = enumArray.getValueType().getComponentType();
                    Enum[] expanded = (Enum[])Array.newInstance(type, arr.length + 1);
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = ((Enum[])type.getEnumConstants())[0];
                    enumArray.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    Enum[] arr = (Enum[])enumArray.get();
                    Class<?> type = enumArray.getValueType().getComponentType();
                    enumArray.set(trimmer.trim(i, arr, (Enum[])Array.newInstance(type, arr.length - 1)));
                });
                client.func_147108_a(screen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static DisplayAdapter objectValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            ObjectValue objectValue = (ObjectValue)value;
            Map valueMap = (Map)objectValue.get();
            Button.IPressable pressable = btn -> {
                Minecraft client = Minecraft.func_71410_x();
                Screen currentScreen = client.field_71462_r;
                ConfigScreen nestedConfigScreen = new ConfigScreen(container.getComponentName(), configId, valueMap, currentScreen);
                client.func_147108_a((Screen)nestedConfigScreen);
            };
            return new Button(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, ConfigEntryWidget.EDIT, pressable);
        });
    }

    public static int getValueX(int x, int width) {
        return x + width - DisplayAdapter.getValueWidth(width);
    }

    public static int getValueWidth(int width) {
        return width / 3;
    }
}

