/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.IValidationHandler;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.io.ConfigIO;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.ObjectValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class AbstractConfigScreen
extends Screen {
    public static final int HEADER_HEIGHT = 35;
    public static final int FOOTER_HEIGHT = 30;
    public static final Marker MARKER = MarkerManager.getMarker((String)"Screen");
    protected final Screen last;
    protected final String configId;
    protected int index;
    protected int pageSize;

    public AbstractConfigScreen(ITextComponent title, Screen previous, String configId) {
        super(title);
        this.last = previous;
        this.configId = configId;
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.saveConfig(true);
    }

    public static void renderScrollbar(MatrixStack stack, int x, int y, int width, int height, int index, int valueCount, int paging) {
        if (valueCount <= paging) {
            return;
        }
        double step = (double)height / (double)valueCount;
        int min = MathHelper.func_76128_c((double)((double)index * step));
        int max = MathHelper.func_76143_f((double)((double)(index + paging) * step));
        int y1 = y + min;
        int y2 = y + max;
        AbstractConfigScreen.func_238467_a_((MatrixStack)stack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-16777216);
        AbstractConfigScreen.func_238467_a_((MatrixStack)stack, (int)x, (int)y1, (int)(x + width), (int)y2, (int)-7829368);
        AbstractConfigScreen.func_238467_a_((MatrixStack)stack, (int)x, (int)y1, (int)(x + width - 1), (int)(y2 - 1), (int)-1118482);
        AbstractConfigScreen.func_238467_a_((MatrixStack)stack, (int)(x + 1), (int)(y1 + 1), (int)(x + width - 1), (int)(y2 - 1), (int)-3355444);
    }

    protected void addFooter() {
        int centerY = this.field_230709_l_ - 30 + 5;
        this.func_230480_a_((Widget)new Button(20, centerY, 50, 20, ConfigEntryWidget.BACK, this::buttonBackClicked));
        this.func_230480_a_((Widget)new Button(75, centerY, 120, 20, ConfigEntryWidget.REVERT_DEFAULTS, this::buttonRevertToDefaultClicked));
        this.func_230480_a_((Widget)new Button(200, centerY, 120, 20, ConfigEntryWidget.REVERT_CHANGES, this::buttonRevertChangesClicked));
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    protected Screen getFirstNonConfigScreen() {
        Screen screen = this.last;
        while (screen instanceof ConfigScreen) {
            screen = ((ConfigScreen)screen).last;
        }
        return screen;
    }

    private void buttonBackClicked(Button button) {
        this.field_230706_i_.func_147108_a(this.last);
        this.saveConfig();
    }

    private void buttonRevertToDefaultClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_DEFAULTS, new ITextComponent[]{ConfigEntryWidget.REVERT_DEFAULTS_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            Configuration.LOGGER.info(MARKER, "Reverting config {} to default values", (Object)this.configId);
            ConfigHolder.getConfig(this.configId).ifPresent(holder -> {
                this.revertToDefault(holder.values());
                ConfigIO.saveClientValues(holder);
            });
            this.backToConfigList();
        });
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void buttonRevertChangesClicked(Button button) {
        DialogScreen dialog = new DialogScreen(ConfigEntryWidget.REVERT_CHANGES, new ITextComponent[]{ConfigEntryWidget.REVERT_CHANGES_DIALOG_TEXT}, this);
        dialog.onConfirmed(screen -> {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::reloadClientValues);
            this.backToConfigList();
        });
        this.field_230706_i_.func_147108_a((Screen)dialog);
    }

    private void revertToDefault(Collection<ConfigValue<?>> configValues) {
        configValues.forEach(val -> {
            if (val instanceof ObjectValue) {
                ObjectValue objVal = (ObjectValue)val;
                this.revertToDefault(((Map)objVal.get()).values());
            } else {
                val.useDefaultValue();
            }
        });
    }

    private void backToConfigList() {
        this.field_230706_i_.func_147108_a(this.getFirstNonConfigScreen());
        this.saveConfig();
    }

    private void saveConfig() {
        this.saveConfig(false);
    }

    private void saveConfig(boolean force) {
        if (force || !(this.last instanceof AbstractConfigScreen)) {
            ConfigHolder.getConfig(this.configId).ifPresent(ConfigIO::saveClientValues);
        }
    }

    public void renderNotification(NotificationSeverity severity, MatrixStack stack, List<IReorderingProcessor> texts, int mouseX, int mouseY) {
        if (!texts.isEmpty()) {
            int maxTextWidth = 0;
            int iconOffset = 13;
            for (IReorderingProcessor textComponent : texts) {
                int textWidth = this.field_230712_o_.func_243245_a(textComponent);
                if (!severity.isOkStatus()) {
                    textWidth += iconOffset;
                }
                if (textWidth <= maxTextWidth) continue;
                maxTextWidth = textWidth;
            }
            int startX = mouseX + 12;
            int startY = mouseY - 12;
            int heightOffset = 8;
            if (texts.size() > 1) {
                heightOffset += 2 + (texts.size() - 1) * 10;
            }
            if (startX + maxTextWidth > this.field_230708_k_) {
                startX -= 28 + maxTextWidth;
            }
            if (startY + heightOffset + 6 > this.field_230709_l_) {
                startY = this.field_230709_l_ - heightOffset - 6;
            }
            stack.func_227860_a_();
            int background = severity.background;
            int fadeMin = severity.fadeMin;
            int fadeMax = severity.fadeMax;
            int zIndex = 400;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 4), (int)(startX + maxTextWidth + 3), (int)(startY - 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY + heightOffset + 3), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 4), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 4), (int)(startY - 3), (int)(startX - 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX + maxTextWidth + 3), (int)(startY - 3), (int)(startX + maxTextWidth + 4), (int)(startY + heightOffset + 3), (int)zIndex, (int)background, (int)background);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3 + 1), (int)(startX - 3 + 1), (int)(startY + heightOffset + 3 - 1), (int)zIndex, (int)fadeMin, (int)fadeMax);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX + maxTextWidth + 2), (int)(startY - 3 + 1), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3 - 1), (int)zIndex, (int)fadeMin, (int)fadeMax);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY - 3), (int)(startX + maxTextWidth + 3), (int)(startY - 3 + 1), (int)zIndex, (int)fadeMin, (int)fadeMin);
            AbstractConfigScreen.func_238462_a_((Matrix4f)matrix4f, (BufferBuilder)bufferbuilder, (int)(startX - 3), (int)(startY + heightOffset + 2), (int)(startX + maxTextWidth + 3), (int)(startY + heightOffset + 3), (int)zIndex, (int)fadeMax, (int)fadeMax);
            RenderSystem.enableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.shadeModel((int)7425);
            bufferbuilder.func_178977_d();
            WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            RenderSystem.shadeModel((int)7424);
            RenderSystem.enableTexture();
            if (!severity.isOkStatus()) {
                this.field_230706_i_.func_110434_K().func_110577_a(severity.getIcon());
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float min = -0.5f;
                float max = 8.5f;
                bufferbuilder.func_227888_a_(matrix4f, (float)startX + min, (float)startY + min, (float)zIndex).func_225583_a_(0.0f, 0.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix4f, (float)startX + min, (float)startY + max, (float)zIndex).func_225583_a_(0.0f, 1.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix4f, (float)startX + max, (float)startY + max, (float)zIndex).func_225583_a_(1.0f, 1.0f).func_181675_d();
                bufferbuilder.func_227888_a_(matrix4f, (float)startX + max, (float)startY + min, (float)zIndex).func_225583_a_(1.0f, 0.0f).func_181675_d();
                bufferbuilder.func_178977_d();
                WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
            }
            RenderSystem.disableBlend();
            IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            stack.func_227861_a_(0.0, 0.0, (double)zIndex);
            int textOffset = severity.isOkStatus() ? 0 : iconOffset;
            for (int i = 0; i < texts.size(); ++i) {
                IReorderingProcessor textComponent = texts.get(i);
                if (textComponent != null) {
                    this.field_230712_o_.func_238416_a_(textComponent, (float)startX + (float)textOffset, (float)startY, -1, true, matrix4f, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
                }
                if (i == 0) {
                    startY += 2;
                }
                startY += 10;
            }
            irendertypebuffer$impl.func_228461_a_();
            stack.func_227865_b_();
        }
    }

    protected <T> void initializeGuiValue(ConfigValue<T> value, IValidationHandler handler) {
        T t = value.get();
        value.setWithValidationHandler(t, handler);
    }
}

