/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.client.DisplayAdapterManager;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.adapter.TypeAdapters;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.value.ArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArrayConfigScreen<V, C extends ConfigValue<V>>
extends AbstractConfigScreen {
    public static final ITextComponent ADD_ELEMENT = new TranslationTextComponent("text.configuration.value.add_element");
    public final C array;
    private final boolean fixedSize;
    private Supplier<Integer> sizeSupplier = () -> 0;
    private DummyConfigValueFactory valueFactory;
    private ElementAddHandler addHandler;
    private ElementRemoveHandler<V> removeHandler;

    public ArrayConfigScreen(String ownerIdentifier, String configId, C array, Screen previous) {
        super((ITextComponent)new TranslationTextComponent(String.format("config.%s.option.%s", configId, ownerIdentifier)), previous, configId);
        this.array = array;
        this.fixedSize = ((ArrayValue)array).isFixedSize();
    }

    public void fetchSize(Supplier<Integer> integerSupplier) {
        this.sizeSupplier = integerSupplier;
    }

    public void valueFactory(DummyConfigValueFactory factory) {
        this.valueFactory = factory;
    }

    public void addElement(ElementAddHandler handler) {
        this.addHandler = handler;
    }

    public void removeElement(ElementRemoveHandler<V> handler) {
        this.removeHandler = handler;
    }

    protected void func_231160_c_() {
        int viewportMin = 35;
        int viewportHeight = this.field_230709_l_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.sizeSupplier.get());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        Class<?> compType = ((ConfigValue)this.array).get().getClass().getComponentType();
        DisplayAdapter adapter = DisplayAdapterManager.forType(compType);
        TypeAdapter.AdapterContext context = ((ConfigValue)this.array).getSerializationContext();
        Field owner = context.getOwner();
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.sizeSupplier.get()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue<?> dummy = this.valueFactory.create(((ConfigValue)this.array).getId(), i);
            dummy.processFieldData(owner);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.func_230480_a_(new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.field_230708_k_ - 60, 20, dummy, this.configId));
            widget.setDescriptionRenderer(this::renderEntryDescription);
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)compType.getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(dummy, owner, widget);
                this.initializeGuiValue(dummy, widget);
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)compType.getSimpleName(), (Object)e);
            }
            if (this.fixedSize) continue;
            int elementIndex = i;
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 28, widget.field_230691_m_, 20, 20, (ITextComponent)new StringTextComponent("x"), btn -> {
                this.removeHandler.removeElementAt(elementIndex, (index, src, dest) -> {
                    System.arraycopy(src, 0, dest, 0, index);
                    System.arraycopy(src, index + 1, dest, index, this.sizeSupplier.get() - 1 - index);
                    return dest;
                });
                this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            }));
        }
        this.addFooter();
    }

    private void renderEntryDescription(MatrixStack stack, Widget widget, NotificationSeverity severity, List<IReorderingProcessor> text) {
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, stack, text, widget.field_230690_l_ + 5, widget.field_230691_m_ + widget.func_238483_d_() + 10);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_);
        float f = (float)(this.field_230708_k_ - titleWidth) / 2.0f;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ArrayConfigScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)35, (int)this.field_230708_k_, (int)(this.field_230709_l_ - 30), (int)-1728053248);
        ArrayConfigScreen.renderScrollbar(stack, this.field_230708_k_ - 5, 35, 5, this.field_230709_l_ - 30 - 35, this.index, this.sizeSupplier.get(), this.pageSize);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void addFooter() {
        super.addFooter();
        if (!this.fixedSize) {
            int centerY = this.field_230709_l_ - 30 + 5;
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 20 - 80, centerY, 80, 20, ADD_ELEMENT, btn -> {
                this.addHandler.insertElement();
                this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            }));
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.sizeSupplier.get()) {
            this.index = next;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            return true;
        }
        return false;
    }

    public static <V> TypeAdapter.AdapterContext callbackCtx(Field parent, Class<V> componentType, BiConsumer<V, Integer> callback, int index) {
        return new DummyCallbackAdapter(componentType, parent, callback, index);
    }

    private static class DummyCallbackAdapter<V>
    implements TypeAdapter.AdapterContext {
        private final TypeAdapter typeAdapter;
        private final Field parentField;
        private final BiConsumer<V, Integer> setCallback;
        private final int index;

        private DummyCallbackAdapter(Class<V> type, Field parentField, BiConsumer<V, Integer> setCallback, int index) {
            this.typeAdapter = TypeAdapters.forType(type);
            this.parentField = parentField;
            this.setCallback = setCallback;
            this.index = index;
        }

        @Override
        public TypeAdapter getAdapter() {
            return this.typeAdapter;
        }

        @Override
        public Field getOwner() {
            return this.parentField;
        }

        @Override
        public void setFieldValue(Object value) {
            this.setCallback.accept(value, this.index);
        }
    }

    @FunctionalInterface
    public static interface ElementRemoveHandler<V> {
        public void removeElementAt(int var1, ArrayTrimmer<V> var2);

        @FunctionalInterface
        public static interface ArrayTrimmer<V> {
            public V trim(int var1, V var2, V var3);
        }
    }

    @FunctionalInterface
    public static interface DummyConfigValueFactory {
        public ConfigValue<?> create(String var1, int var2);
    }

    @FunctionalInterface
    public static interface ElementAddHandler {
        public void insertElement();
    }
}

