/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.screen.ConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.ConfigHolder;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigGroupScreen
extends Screen {
    protected final Screen last;
    protected final String groupId;
    protected final List<ConfigHolder<?>> configHolders;
    protected int index;
    protected int pageSize;

    public ConfigGroupScreen(Screen last, String groupId, List<ConfigHolder<?>> configHolders) {
        super((ITextComponent)new TranslationTextComponent("text.configuration.screen.select_config"));
        this.last = last;
        this.groupId = groupId;
        this.configHolders = configHolders;
    }

    protected void func_231160_c_() {
        int viewportMin = 35;
        int viewportHeight = this.field_230709_l_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.configHolders.size());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        int posX = 30;
        int componentWidth = this.field_230708_k_ - 2 * posX;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.configHolders.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigHolder<?> value = this.configHolders.get(i);
            int y = 45 + j * 25 + (offset += correct);
            String configId = value.getConfigId();
            this.func_230480_a_(new LeftAlignedLabel(posX, y, componentWidth, 20, (ITextComponent)new TranslationTextComponent("config.screen." + configId), this.field_230712_o_));
            this.func_230480_a_((Widget)new Button(DisplayAdapter.getValueX(posX, componentWidth), y, DisplayAdapter.getValueWidth(componentWidth), 20, ConfigEntryWidget.EDIT, btn -> {
                ConfigScreen screen = new ConfigScreen(configId, configId, value.getValueMap(), (Screen)this);
                this.field_230706_i_.func_147108_a((Screen)screen);
            }));
        }
        this.initFooter();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_);
        float f = (float)(this.field_230708_k_ - titleWidth) / 2.0f;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigGroupScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)35, (int)this.field_230708_k_, (int)(this.field_230709_l_ - 30), (int)-1728053248);
        AbstractConfigScreen.renderScrollbar(stack, this.field_230708_k_ - 5, 35, 5, this.field_230709_l_ - 30 - 35, this.index, this.configHolders.size(), this.pageSize);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    protected void initFooter() {
        int centerY = this.field_230709_l_ - 30 + 5;
        this.func_230480_a_((Widget)new Button(20, centerY, 50, 20, ConfigEntryWidget.BACK, btn -> this.field_230706_i_.func_147108_a(this.last)));
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
            this.index = next;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            return true;
        }
        return false;
    }

    protected static final class LeftAlignedLabel
    extends Widget {
        private final FontRenderer font;

        public LeftAlignedLabel(int x, int y, int width, int height, ITextComponent label, FontRenderer font) {
            super(x, y, width, height, label);
            this.font = font;
        }

        public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
            ITextComponent iTextComponent = this.func_230458_i_();
            float f = this.field_230690_l_;
            float f2 = this.field_230691_m_;
            this.font.getClass();
            this.font.func_243248_b(stack, iTextComponent, f, f2 + (float)(this.field_230689_k_ - 9) / 2.0f, 0xAAAAAA);
        }

        protected boolean func_230987_a_(int p_230987_1_) {
            return false;
        }
    }
}

