/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.configuration.Configuration;
import dev.toma.configuration.client.DisplayAdapter;
import dev.toma.configuration.client.DisplayAdapterManager;
import dev.toma.configuration.client.screen.AbstractConfigScreen;
import dev.toma.configuration.client.widget.ConfigEntryWidget;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.value.ConfigValue;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigScreen
extends AbstractConfigScreen {
    private final Map<String, ConfigValue<?>> valueMap;

    public ConfigScreen(String ownerIdentifier, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        this((ITextComponent)new TranslationTextComponent("config.screen." + ownerIdentifier), configId, valueMap, previous);
    }

    public ConfigScreen(ITextComponent screenTitle, String configId, Map<String, ConfigValue<?>> valueMap, Screen previous) {
        super(screenTitle, previous, configId);
        this.valueMap = valueMap;
    }

    protected void func_231160_c_() {
        int viewportMin = 35;
        int viewportHeight = this.field_230709_l_ - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.valueMap.size());
        ArrayList values = new ArrayList(this.valueMap.values());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= values.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigValue value = (ConfigValue)values.get(i);
            ConfigEntryWidget widget = (ConfigEntryWidget)this.func_230480_a_(new ConfigEntryWidget(30, 45 + j * 25 + (offset += correct), this.field_230708_k_ - 60, 20, value, this.configId));
            widget.setDescriptionRenderer(this::renderEntryDescription);
            TypeAdapter.AdapterContext context = value.getSerializationContext();
            Field field = context.getOwner();
            DisplayAdapter adapter = DisplayAdapterManager.forType(field.getType());
            if (adapter == null) {
                Configuration.LOGGER.error(MARKER, "Missing display adapter for {} type, will not be displayed in GUI", (Object)field.getType().getSimpleName());
                continue;
            }
            try {
                adapter.placeWidgets(value, field, widget);
                this.initializeGuiValue(value, widget);
                continue;
            }
            catch (ClassCastException e) {
                Configuration.LOGGER.error(MARKER, "Unable to create config field for {} type due to error {}", (Object)field.getType().getSimpleName(), (Object)e);
            }
        }
        this.addFooter();
    }

    private void renderEntryDescription(MatrixStack stack, Widget widget, NotificationSeverity severity, List<IReorderingProcessor> text) {
        int x = widget.field_230690_l_ + 5;
        int y = widget.field_230691_m_ + widget.func_238483_d_() + 10;
        if (!severity.isOkStatus()) {
            this.renderNotification(severity, stack, text, x, y);
        } else {
            this.renderNotification(NotificationSeverity.INFO, stack, text, x, y);
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        int titleWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_);
        float f = (float)(this.field_230708_k_ - titleWidth) / 2.0f;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigScreen.func_238467_a_((MatrixStack)stack, (int)0, (int)35, (int)this.field_230708_k_, (int)(this.field_230709_l_ - 30), (int)-1728053248);
        ConfigScreen.renderScrollbar(stack, this.field_230708_k_ - 5, 35, 5, this.field_230709_l_ - 30 - 35, this.index, this.valueMap.size(), this.pageSize);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.valueMap.size()) {
            this.index = next;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
            return true;
        }
        return false;
    }
}

