/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class DialogScreen
extends Screen {
    public static final ITextComponent TEXT_CONFIRM = new TranslationTextComponent("text.configuration.screen.dialog.confirm");
    public static final ITextComponent TEXT_CANCEL = new TranslationTextComponent("text.configuration.screen.dialog.cancel");
    private final Screen background;
    private DialogRespondEvent onCancel;
    private DialogRespondEvent onConfirm;
    protected final ITextComponent[] text;
    protected int dialogWidth;
    protected int dialogHeight;
    protected int dialogLeft;
    protected int dialogTop;
    private List<IReorderingProcessor> splitText = new ArrayList<IReorderingProcessor>();

    public DialogScreen(ITextComponent title, ITextComponent[] text, Screen background) {
        super(title);
        this.text = text;
        this.background = background;
        this.onCancel = this::displayPreviousScreen;
        this.onConfirm = this::displayPreviousScreen;
    }

    public void onCancelled(DialogRespondEvent cancelEvent) {
        this.onCancel = Objects.requireNonNull(cancelEvent);
    }

    public void onConfirmed(DialogRespondEvent confirmEvent) {
        this.onConfirm = Objects.requireNonNull(confirmEvent);
    }

    public void setDimensions(int dialogWidth, int dialogHeight) {
        this.dialogWidth = dialogWidth;
        this.dialogHeight = dialogHeight;
        this.dialogLeft = (this.field_230708_k_ - this.dialogWidth) / 2;
        this.dialogTop = (this.field_230709_l_ - this.dialogHeight) / 2;
        this.splitText = Arrays.stream(this.text).map(line -> this.field_230712_o_.func_238425_b_((ITextProperties)line, this.dialogWidth - 10)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected void func_231160_c_() {
        this.background.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        this.setDimensions(140, 100);
        this.addDefaultDialogButtons();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int backgroundColor = -16777216;
        this.background.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.func_238468_a_(stack, this.dialogLeft - 1, this.dialogTop - 1, this.dialogLeft + this.dialogWidth + 1, this.dialogTop + this.dialogHeight + 1, -1, -1);
        this.func_238468_a_(stack, this.dialogLeft, this.dialogTop, this.dialogLeft + this.dialogWidth, this.dialogTop + this.dialogHeight, backgroundColor, backgroundColor);
        this.renderForeground(stack, mouseX, mouseY, partialTicks);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (this.allowKeyboardInteractions()) {
            if (keyCode == 256) {
                this.cancel();
                return true;
            }
            if (keyCode == 257 || keyCode == 335) {
                this.confirm();
                return true;
            }
            return false;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    protected void renderForeground(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        int headerWidth = this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_);
        this.field_230712_o_.func_243248_b(stack, this.field_230704_d_, (float)this.dialogLeft + (float)(this.dialogWidth - headerWidth) / 2.0f, (float)(this.dialogTop + 5), 0xFFFFFF);
        int line = 0;
        for (IReorderingProcessor textLine : this.splitText) {
            this.field_230712_o_.func_238422_b_(stack, textLine, (float)(this.dialogLeft + 5), (float)(this.dialogTop + 20 + line * 10), 0xFFFFFF);
            ++line;
        }
    }

    protected void addDefaultDialogButtons() {
        int useableWidth = this.dialogWidth - 15;
        int componentWidth = useableWidth / 2;
        int cancelX = this.dialogLeft + 5;
        int confirmX = this.dialogLeft + this.dialogWidth - 5 - componentWidth;
        int componentY = this.dialogTop + this.dialogHeight - 25;
        this.func_230480_a_((Widget)new Button(cancelX, componentY, componentWidth, 20, TEXT_CANCEL, btn -> this.cancel()));
        this.func_230480_a_((Widget)new Button(confirmX, componentY, componentWidth, 20, TEXT_CONFIRM, btn -> this.confirm()));
    }

    protected void confirm() {
        this.onConfirm.respond(this);
    }

    protected void cancel() {
        this.onCancel.respond(this);
    }

    public void displayPreviousScreen(DialogScreen screen) {
        this.field_230706_i_.func_147108_a(this.background);
    }

    protected boolean allowKeyboardInteractions() {
        return true;
    }

    @FunctionalInterface
    public static interface DialogRespondEvent {
        public void respond(DialogScreen var1);
    }
}

