/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.configuration.client.screen.DialogScreen;
import dev.toma.configuration.config.Configurable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ColorWidget
extends Widget {
    public static final ITextComponent SELECT_COLOR = new TranslationTextComponent("text.configuration.screen.color_dialog");
    private final boolean argb;
    private final String colorPrefix;
    private final IntSupplier colorSupplier;
    private final GetSet<String> colorWidget;
    private final Screen lastScreen;

    public ColorWidget(int x, int y, int width, int height, Configurable.Gui.ColorValue colorOptions, GetSet<String> colorWidget, Screen lastScreen) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
        this.argb = colorOptions.isARGB();
        this.colorPrefix = colorOptions.getGuiColorPrefix();
        this.colorWidget = colorWidget;
        this.colorSupplier = () -> {
            String rawColor = (String)colorWidget.get();
            try {
                long longClr = Long.decode(rawColor);
                return (int)longClr;
            }
            catch (NumberFormatException e) {
                return 0;
            }
        };
        this.lastScreen = lastScreen;
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialRenderTicks) {
        int borderColor = this.func_230999_j_() ? -1 : -6250336;
        int providedColor = this.colorSupplier.getAsInt();
        int color = this.argb ? providedColor : 0xFF000000 | providedColor;
        ColorWidget.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ - 1), (int)(this.field_230691_m_ - 1), (int)(this.field_230690_l_ + this.field_230688_j_ + 1), (int)(this.field_230691_m_ + this.field_230689_k_ + 1), (int)borderColor);
        this.func_238468_a_(stack, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, -1, -7829368);
        ColorWidget.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)color);
    }

    protected boolean func_230987_a_(int button) {
        return button == 0;
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        ColorSelectorDialog dialog = new ColorSelectorDialog(SELECT_COLOR, this.lastScreen, this.argb, this.colorSupplier);
        dialog.onConfirmed(screen -> {
            int color = dialog.getResultColor();
            String colorText = this.colorPrefix + Integer.toHexString(color).toUpperCase();
            this.colorWidget.set(colorText);
            dialog.displayPreviousScreen(dialog);
        });
        Minecraft.func_71410_x().func_147108_a((Screen)dialog);
    }

    private static final class ColorSelectorDialog
    extends DialogScreen {
        private final boolean argb;
        private final IntSupplier colorProvider;
        private final List<ColorSlider> sliders = new ArrayList<ColorSlider>();

        public ColorSelectorDialog(ITextComponent title, Screen background, boolean allowTransparency, IntSupplier colorProvider) {
            super(title, new ITextComponent[0], background);
            this.argb = allowTransparency;
            this.colorProvider = colorProvider;
        }

        @Override
        protected void func_231160_c_() {
            this.sliders.clear();
            int width = 190;
            int height = 120;
            int rightMargin = 85;
            if (this.argb) {
                height = 150;
                rightMargin = 110;
                width = 230;
            }
            super.func_231160_c_();
            this.setDimensions(width, height);
            int color = this.colorProvider.getAsInt();
            this.sliders.add((ColorSlider)this.func_230480_a_((Widget)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 20, this.dialogWidth - rightMargin, 20, color, ColorComponent.RED)));
            this.sliders.add((ColorSlider)this.func_230480_a_((Widget)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 45, this.dialogWidth - rightMargin, 20, color, ColorComponent.GREEN)));
            this.sliders.add((ColorSlider)this.func_230480_a_((Widget)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 70, this.dialogWidth - rightMargin, 20, color, ColorComponent.BLUE)));
            if (this.argb) {
                this.sliders.add((ColorSlider)this.func_230480_a_((Widget)new ColorSlider(this.dialogLeft + 5, this.dialogTop + 95, this.dialogWidth - rightMargin, 20, color, ColorComponent.ALPHA)));
            }
            this.func_230480_a_(new ColorDisplay(this.dialogLeft + 5 + this.dialogWidth - rightMargin + 5, this.dialogTop + 20, rightMargin - 15, rightMargin - 15, this.argb, this::getResultColor));
            super.addDefaultDialogButtons();
        }

        @Override
        protected void addDefaultDialogButtons() {
        }

        public int getResultColor() {
            int color = 0;
            for (ColorSlider slider : this.sliders) {
                color |= slider.getColor();
            }
            return color;
        }

        private static enum ColorComponent {
            ALPHA(24),
            RED(16),
            GREEN(8),
            BLUE(0);

            private final int bitOffset;
            private final Function<Double, ITextComponent> title;

            private ColorComponent(int bitOffset) {
                this.bitOffset = bitOffset;
                this.title = val -> {
                    String name = this.name().toLowerCase();
                    String translate = "text.configuration.screen.color." + name;
                    int colorValue = (int)(val * 255.0);
                    return new TranslationTextComponent(translate, new Object[]{colorValue});
                };
            }

            public int getOffsetColor(int value) {
                return value << this.bitOffset;
            }

            public int getByteColor(int value) {
                return value >> this.bitOffset & 0xFF;
            }

            public ITextComponent updateTitle(double sliderValue) {
                return this.title.apply(sliderValue);
            }
        }

        private static final class ColorSlider
        extends AbstractSlider {
            private final ColorComponent colorComponent;

            public ColorSlider(int x, int y, int width, int height, int color, ColorComponent colorComponent) {
                super(x, y, width, height, StringTextComponent.field_240750_d_, (double)colorComponent.getByteColor(color) / 255.0);
                this.colorComponent = colorComponent;
                this.func_230979_b_();
            }

            protected void func_230979_b_() {
                ITextComponent colorLabel = this.colorComponent.updateTitle(this.field_230683_b_);
                this.func_238482_a_(colorLabel);
            }

            protected void func_230972_a_() {
            }

            int getColor() {
                return this.colorComponent.getOffsetColor((int)(255.0 * this.field_230683_b_));
            }
        }

        private static final class ColorDisplay
        extends Widget {
            private final boolean argb;
            private final IntSupplier colorProvider;

            public ColorDisplay(int x, int y, int width, int height, boolean argb, IntSupplier colorProvider) {
                super(x, y, width, height, StringTextComponent.field_240750_d_);
                this.argb = argb;
                this.colorProvider = colorProvider;
            }

            public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
                int color = this.colorProvider.getAsInt();
                if (!this.argb) {
                    color |= 0xFF000000;
                }
                int borderColor = -6250336;
                ColorDisplay.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)borderColor);
                this.func_238468_a_(stack, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.field_230690_l_ + this.field_230688_j_ - 1, this.field_230691_m_ + this.field_230689_k_ - 1, -1, -7829368);
                ColorDisplay.func_238467_a_((MatrixStack)stack, (int)(this.field_230690_l_ + 1), (int)(this.field_230691_m_ + 1), (int)(this.field_230690_l_ + this.field_230688_j_ - 1), (int)(this.field_230691_m_ + this.field_230689_k_ - 1), (int)color);
            }

            protected boolean func_230987_a_(int button) {
                return false;
            }
        }
    }

    public static interface GetSet<T> {
        public T get();

        public void set(T var1);

        public static <T> GetSet<T> of(final Supplier<T> get, final Consumer<T> set) {
            return new GetSet<T>(){

                @Override
                public T get() {
                    return get.get();
                }

                @Override
                public void set(T t) {
                    set.accept(t);
                }
            };
        }
    }
}

