/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.client.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.configuration.client.WidgetAdder;
import dev.toma.configuration.client.widget.ContainerWidget;
import dev.toma.configuration.config.validate.NotificationSeverity;
import dev.toma.configuration.config.validate.ValidationResult;
import dev.toma.configuration.config.value.ConfigValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final ITextComponent EDIT = new TranslationTextComponent("text.configuration.value.edit");
    public static final ITextComponent BACK = new TranslationTextComponent("text.configuration.value.back");
    public static final ITextComponent REVERT_DEFAULTS = new TranslationTextComponent("text.configuration.value.revert.default");
    public static final ITextComponent REVERT_DEFAULTS_DIALOG_TEXT = new TranslationTextComponent("text.configuration.value.revert.default.dialog");
    public static final ITextComponent REVERT_CHANGES = new TranslationTextComponent("text.configuration.value.revert.changes");
    public static final ITextComponent REVERT_CHANGES_DIALOG_TEXT = new TranslationTextComponent("text.configuration.value.revert.changes.dialog");
    private final String configId;
    private final List<ITextComponent> description;
    private ValidationResult result = ValidationResult.ok();
    private IDescriptionRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId) {
        super(x, y, w, h, (ITextComponent)new TranslationTextComponent("config." + configId + ".option." + value.getId()));
        this.configId = configId;
        this.description = Arrays.stream(value.getDescription()).map(text -> new StringTextComponent(text).func_240699_a_(TextFormatting.GRAY)).collect(Collectors.toList());
    }

    public void setDescriptionRenderer(IDescriptionRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public ITextComponent getComponentName() {
        return this.func_230458_i_();
    }

    @Override
    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        if (!this.lastHoverState && this.field_230692_n_) {
            this.hoverTimeStart = System.currentTimeMillis();
        }
        boolean isError = !this.result.isOk();
        ITextComponent iTextComponent = this.func_230458_i_();
        float f = this.field_230690_l_;
        float f2 = this.field_230691_m_;
        font.getClass();
        font.func_243248_b(stack, iTextComponent, f, f2 + (float)(this.field_230689_k_ - 9) / 2.0f, 0xAAAAAA);
        super.func_230431_b_(stack, mouseX, mouseY, partialTicks);
        if ((isError || this.field_230692_n_) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                NotificationSeverity severity = this.result.getSeverity();
                IFormattableTextComponent textComponent = this.result.getText().func_240699_a_(severity.getExtraFormatting());
                List<IFormattableTextComponent> desc = isError ? Collections.singletonList(textComponent) : this.description;
                List<IReorderingProcessor> split = desc.stream().flatMap(text -> font.func_238425_b_((ITextProperties)text, this.field_230688_j_ / 2).stream()).collect(Collectors.toList());
                this.renderer.drawDescription(stack, this, severity, split);
            }
        }
        this.lastHoverState = this.field_230692_n_;
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends Widget> W addConfigWidget(WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.field_230690_l_, this.field_230691_m_, this.field_230688_j_, this.field_230689_k_, this.configId);
        return this.addWidget(widget);
    }

    @FunctionalInterface
    public static interface IDescriptionRenderer {
        public void drawDescription(MatrixStack var1, Widget var2, NotificationSeverity var3, List<IReorderingProcessor> var4);
    }
}

