/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.validate;

import dev.toma.configuration.config.validate.NotificationSeverity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;

public final class ValidationResult {
    private static final ValidationResult OK = new ValidationResult(NotificationSeverity.INFO, (IFormattableTextComponent)StringTextComponent.field_240750_d_);
    private final NotificationSeverity severity;
    private final IFormattableTextComponent text;

    public ValidationResult(NotificationSeverity severity, IFormattableTextComponent text) {
        this.severity = severity;
        this.text = text;
    }

    public static ValidationResult ok() {
        return OK;
    }

    public static ValidationResult warn(IFormattableTextComponent text) {
        return new ValidationResult(NotificationSeverity.WARNING, text);
    }

    public static ValidationResult error(IFormattableTextComponent text) {
        return new ValidationResult(NotificationSeverity.ERROR, text);
    }

    public boolean isOk() {
        return this.severity.isOkStatus();
    }

    public NotificationSeverity getSeverity() {
        return this.severity;
    }

    public IFormattableTextComponent getText() {
        return this.text;
    }
}

