/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.config.value;

import dev.toma.configuration.config.ConfigUtils;
import dev.toma.configuration.config.Configurable;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.exception.ConfigValueMissingException;
import dev.toma.configuration.config.format.IConfigFormat;
import dev.toma.configuration.config.value.ArrayValue;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.config.value.IntegerValue;
import dev.toma.configuration.config.value.ValueData;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.PacketBuffer;

public class LongArrayValue
extends ConfigValue<long[]>
implements ArrayValue {
    private boolean fixedSize;
    private IntegerValue.Range range;

    public LongArrayValue(ValueData<long[]> valueData) {
        super(valueData);
    }

    @Override
    public boolean isFixedSize() {
        return this.fixedSize;
    }

    @Override
    protected void readFieldData(Field field) {
        this.fixedSize = field.getAnnotation(Configurable.FixedSize.class) != null;
        Configurable.Range intRange = field.getAnnotation(Configurable.Range.class);
        this.range = intRange != null ? IntegerValue.Range.newBoundedRange(intRange.min(), intRange.max()) : IntegerValue.Range.unboundedLong();
    }

    @Override
    protected long[] getCorrectedValue(long[] in) {
        long[] defaultArray;
        if (this.fixedSize && in.length != (defaultArray = (long[])this.valueData.getDefaultValue()).length) {
            ConfigUtils.logArraySizeCorrectedMessage(this.getId(), Arrays.toString(in), Arrays.toString(defaultArray));
            in = defaultArray;
        }
        if (this.range == null) {
            return in;
        }
        for (int i = 0; i < in.length; ++i) {
            long value = in[i];
            if (this.range.isWithin(value)) continue;
            long corrected = this.range.clamp(value);
            ConfigUtils.logCorrectedMessage(this.getId() + "[" + i + "]", value, corrected);
            in[i] = corrected;
        }
        return in;
    }

    @Override
    protected void serialize(IConfigFormat format) {
        format.writeLongArray(this.getId(), (long[])this.get());
    }

    @Override
    protected void deserialize(IConfigFormat format) throws ConfigValueMissingException {
        this.set(format.readLongArray(this.getId()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        long[] longs = (long[])this.get();
        for (int i = 0; i < longs.length; ++i) {
            builder.append(this.elementToString(longs[i]));
            if (i >= longs.length - 1) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public IntegerValue.Range getRange() {
        return this.range;
    }

    public static final class Adapter
    extends TypeAdapter {
        @Override
        public void encodeToBuffer(ConfigValue<?> value, PacketBuffer buffer) {
            long[] arr = (long[])value.get();
            buffer.writeInt(arr.length);
            for (long v : arr) {
                buffer.writeLong(v);
            }
        }

        @Override
        public Object decodeFromBuffer(ConfigValue<?> value, PacketBuffer buffer) {
            long[] arr = new long[buffer.readInt()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = buffer.readLong();
            }
            return arr;
        }

        @Override
        public ConfigValue<?> serialize(String name, String[] comments, Object value, TypeAdapter.TypeSerializer serializer, TypeAdapter.AdapterContext context) throws IllegalAccessException {
            return new LongArrayValue(ValueData.of(name, (long[])value, context, comments));
        }
    }
}

