/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network;

import dev.toma.configuration.network.IPacket;
import dev.toma.configuration.network.S2C_SendConfigData;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class Networking {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Network");
    private static final String NETWORK_VERSION = "2.0.0";
    private static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("configuration", "network_channel")).networkProtocolVersion(() -> "2.0.0").clientAcceptedVersions("2.0.0"::equals).serverAcceptedVersions("2.0.0"::equals).simpleChannel();

    public static void sendClientPacket(ServerPlayerEntity target, IPacket<?> packet) {
        CHANNEL.sendTo(packet, target.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static final class PacketRegistry {
        private static int packetIndex;

        public static void register() {
            PacketRegistry.registerNetworkPacket(S2C_SendConfigData.class);
        }

        private static <P extends IPacket<P>> void registerNetworkPacket(Class<P> packetType) {
            IPacket packet;
            try {
                packet = (IPacket)packetType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ReportedException(CrashReport.func_85055_a((Throwable)e, (String)"Couldn't instantiate packet for registration. Make sure you have provided public constructor with no parameters."));
            }
            CHANNEL.registerMessage(packetIndex++, packetType, IPacket::encode, packet::decode, IPacket::handle);
        }
    }
}

