/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.configuration.network;

import dev.toma.configuration.Configuration;
import dev.toma.configuration.config.ConfigHolder;
import dev.toma.configuration.config.adapter.TypeAdapter;
import dev.toma.configuration.config.value.ConfigValue;
import dev.toma.configuration.network.IPacket;
import dev.toma.configuration.network.Networking;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class S2C_SendConfigData
implements IPacket<S2C_SendConfigData> {
    private final String config;

    S2C_SendConfigData() {
        this.config = null;
    }

    public S2C_SendConfigData(String config) {
        this.config = config;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.config);
        ConfigHolder.getConfig(this.config).ifPresent(data -> {
            Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
            buffer.writeInt(serialized.size());
            for (Map.Entry<String, ConfigValue<?>> entry : serialized.entrySet()) {
                String id = entry.getKey();
                ConfigValue<?> value = entry.getValue();
                TypeAdapter adapter = value.getAdapter();
                buffer.func_180714_a(id);
                adapter.encodeToBuffer(value, buffer);
            }
        });
    }

    @Override
    public S2C_SendConfigData decode(PacketBuffer buffer) {
        String config = buffer.func_218666_n();
        int i = buffer.readInt();
        ConfigHolder.getConfig(config).ifPresent(data -> {
            Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
            for (int j = 0; j < i; ++j) {
                String fieldId = buffer.func_218666_n();
                ConfigValue<?> value = serialized.get(fieldId);
                if (value == null) {
                    Configuration.LOGGER.fatal(Networking.MARKER, "Received unknown config value " + fieldId);
                    throw new RuntimeException("Unknown config field: " + fieldId);
                }
                this.setValue(value, buffer);
            }
        });
        return new S2C_SendConfigData(config);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().setPacketHandled(true);
    }

    private <V> void setValue(ConfigValue<V> value, PacketBuffer buffer) {
        TypeAdapter adapter = value.getAdapter();
        Object v = adapter.decodeFromBuffer(value, buffer);
        value.set(v);
    }
}

