/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.mojang.datafixers.util.Pair;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.inventory.ItemListInventory;
import de.maxhenkel.corpse.corelib.inventory.LockedSlot;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.CorpseContainerBase;
import de.maxhenkel.corpse.gui.Guis;
import de.maxhenkel.corpse.gui.ITransferrable;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CorpseInventoryContainer
extends CorpseContainerBase
implements ITransferrable {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private ItemListInventory mainInventory;
    private ItemListInventory armorInventory;
    private ItemListInventory offHandInventory;

    public CorpseInventoryContainer(int id, PlayerInventory playerInventory, CorpseEntity corpse, boolean editable, boolean history) {
        super(Main.CONTAINER_TYPE_CORPSE_INVENTORY, id, playerInventory, corpse, editable, history);
        int k;
        this.mainInventory = new ItemListInventory(corpse.getDeath().getMainInventory());
        this.armorInventory = new ItemListInventory(corpse.getDeath().getArmorInventory());
        this.offHandInventory = new ItemListInventory(corpse.getDeath().getOffHandInventory());
        for (int i = 0; i < 4; ++i) {
            final int slotIndex = 3 - i;
            this.func_75146_a(new LockedSlot(this.armorInventory, slotIndex, 8 + i * 18, 18, true, !editable){

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[slotIndex]);
                }
            });
        }
        this.func_75146_a(new LockedSlot(this.offHandInventory, 0, 98, 18, true, !editable){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
        for (k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new LockedSlot(this.mainInventory, j + k * 9 + 9, 8 + j * 18, 40 + k * 18, true, !editable));
            }
        }
        for (k = 0; k < 9; ++k) {
            this.func_75146_a(new LockedSlot(this.mainInventory, k, 8 + k * 18, 98, true, !editable));
        }
        this.addPlayerInventorySlots();
    }

    @Override
    public void transferItems() {
        if (!this.isEditable()) {
            return;
        }
        if (!(this.playerInventory.field_70458_d instanceof ServerPlayerEntity)) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)this.playerInventory.field_70458_d;
        NonNullList additionalItems = NonNullList.func_191196_a();
        this.fill((List<ItemStack>)additionalItems, this.mainInventory, (NonNullList<ItemStack>)this.playerInventory.field_70462_a);
        this.fill((List<ItemStack>)additionalItems, this.armorInventory, (NonNullList<ItemStack>)this.playerInventory.field_70460_b);
        this.fill((List<ItemStack>)additionalItems, this.offHandInventory, (NonNullList<ItemStack>)this.playerInventory.field_184439_c);
        additionalItems.addAll(this.corpse.getDeath().getAdditionalItems());
        NonNullList restItems = NonNullList.func_191196_a();
        for (ItemStack stack : additionalItems) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            restItems.add((Object)stack);
        }
        this.corpse.getDeath().getAdditionalItems().clear();
        this.corpse.getDeath().getAdditionalItems().addAll((Collection)restItems);
        if (!this.corpse.getDeath().getAdditionalItems().isEmpty()) {
            Guis.openAdditionalItems(player, this);
        }
    }

    private void fill(List<ItemStack> additionalItems, IInventory inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.func_190926_b()) {
                additionalItems.add(playerStack);
            }
            inventory.func_70299_a(i, ItemStack.field_190927_a);
            playerInv.set(i, (Object)stack);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.corpse.isMainInventoryEmpty() && !this.corpse.isAdditionalInventoryEmpty() && this.playerInventory.field_70458_d instanceof ServerPlayerEntity) {
            Guis.openAdditionalItems((ServerPlayerEntity)this.playerInventory.field_70458_d, this);
        }
    }

    @Override
    public int getInvOffset() {
        return 79;
    }

    @Override
    public int getInventorySize() {
        return 41;
    }
}

