/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.deployer.DeployerMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.MovingInteractionBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.DoorMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.LeverMovingInteraction;
import com.simibubi.create.content.contraptions.components.structureMovement.interaction.TrapdoorMovingInteraction;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;

public class AllInteractionBehaviours {
    private static final HashMap<ResourceLocation, Supplier<MovingInteractionBehaviour>> INTERACT_BEHAVIOURS = new HashMap();

    public static void addInteractionBehaviour(ResourceLocation loc, Supplier<MovingInteractionBehaviour> behaviour) {
        if (INTERACT_BEHAVIOURS.containsKey(loc)) {
            Create.LOGGER.warn("Interaction behaviour for " + loc.toString() + " was overridden");
        }
        INTERACT_BEHAVIOURS.put(loc, behaviour);
    }

    public static void addInteractionBehaviour(Block block, Supplier<MovingInteractionBehaviour> behaviour) {
        AllInteractionBehaviours.addInteractionBehaviour(block.getRegistryName(), behaviour);
    }

    @Nullable
    public static MovingInteractionBehaviour of(ResourceLocation loc) {
        return INTERACT_BEHAVIOURS.get(loc) == null ? null : INTERACT_BEHAVIOURS.get(loc).get();
    }

    @Nullable
    public static MovingInteractionBehaviour of(Block block) {
        return AllInteractionBehaviours.of(block.getRegistryName());
    }

    public static boolean contains(Block block) {
        return INTERACT_BEHAVIOURS.containsKey(block.getRegistryName());
    }

    static void register() {
        AllInteractionBehaviours.addInteractionBehaviour(Blocks.field_150442_at.getRegistryName(), LeverMovingInteraction::new);
        AllInteractionBehaviours.addInteractionBehaviour(AllBlocks.DEPLOYER.getId(), DeployerMovingInteraction::new);
        for (Block trapdoor : ImmutableList.of((Object)Blocks.field_196682_da, (Object)Blocks.field_196636_cW, (Object)Blocks.field_196684_db, (Object)Blocks.field_196638_cX, (Object)Blocks.field_196644_cZ, (Object)Blocks.field_196641_cY, (Object)Blocks.field_235353_mL_, (Object)Blocks.field_235352_mK_)) {
            AllInteractionBehaviours.addInteractionBehaviour(trapdoor.getRegistryName(), TrapdoorMovingInteraction::new);
        }
        for (Block door : ImmutableList.of((Object)Blocks.field_180410_as, (Object)Blocks.field_180413_ao, (Object)Blocks.field_180409_at, (Object)Blocks.field_180414_ap, (Object)Blocks.field_180411_ar, (Object)Blocks.field_180412_aq, (Object)Blocks.field_235361_mT_, (Object)Blocks.field_235360_mS_)) {
            AllInteractionBehaviours.addInteractionBehaviour(door.getRegistryName(), DoorMovingInteraction::new);
        }
    }
}

