/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.dynamictrees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.branches.TrunkShellBlock;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class DynamicTree
extends AbstractBlockBreakQueue {
    private BlockPos startCutPos;

    public DynamicTree(BlockPos startCutPos) {
        this.startCutPos = startCutPos;
    }

    @Override
    public void destroyBlocks(World world, ItemStack toDamage, @Nullable PlayerEntity playerEntity, BiConsumer<BlockPos, ItemStack> drop) {
        BranchBlock start = TreeHelper.getBranch((BlockState)world.func_180495_p(this.startCutPos));
        if (start == null) {
            start = this.setBranchToShellMuse(world, world.func_180495_p(this.startCutPos));
        }
        if (start == null) {
            return;
        }
        world.func_217378_a(null, 2001, this.startCutPos, Block.func_196246_j((BlockState)world.func_180495_p(this.startCutPos)));
        BranchDestructionData data = start.destroyBranchFromNode(world, this.startCutPos, Direction.DOWN, false, (LivingEntity)playerEntity);
        data.leavesDrops.forEach(stackPos -> drop.accept(stackPos.pos.func_177971_a((Vector3i)this.startCutPos), stackPos.stack));
        start.getLogDrops(world, this.startCutPos, data.species, data.woodVolume).forEach(stack -> drop.accept(this.startCutPos, (ItemStack)stack));
    }

    private BranchBlock setBranchToShellMuse(World world, BlockState state) {
        TrunkShellBlock.ShellMuse muse;
        Block block = state.func_177230_c();
        if (block instanceof TrunkShellBlock && (muse = ((TrunkShellBlock)block).getMuse((IBlockReader)world, this.startCutPos)) != null) {
            this.startCutPos = muse.pos;
            return TreeHelper.getBranch((BlockState)muse.state);
        }
        return null;
    }

    public static boolean isDynamicBranch(Block block) {
        return TreeHelper.isBranch((Block)block) || block instanceof TrunkShellBlock;
    }
}

