/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crank;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.crank.HandCrankBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
public class ValveHandleBlock
extends HandCrankBlock {
    private final DyeColor color;
    private final boolean inCreativeTab;

    public static ValveHandleBlock copper(AbstractBlock.Properties properties) {
        return new ValveHandleBlock(properties, null, true);
    }

    public static ValveHandleBlock dyed(AbstractBlock.Properties properties, DyeColor color) {
        return new ValveHandleBlock(properties, color, false);
    }

    private ValveHandleBlock(AbstractBlock.Properties properties, DyeColor color, boolean inCreativeTab) {
        super(properties);
        this.color = color;
        this.inCreativeTab = inCreativeTab;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color != null && color != this.color) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState newState = BlockHelper.copyProperties(state, AllBlocks.DYED_VALVE_HANDLES.get(color).getDefaultState());
            world.func_175656_a(pos, newState);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> p_149666_2_) {
        if (group != ItemGroup.field_78027_g && !this.inCreativeTab) {
            return;
        }
        super.func_149666_a(group, p_149666_2_);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getRenderedHandle() {
        return null;
    }

    @Override
    public int getRotationSpeed() {
        return 16;
    }
}

