/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.google.gson.JsonObject;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.IAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DeployerApplicationRecipe
extends ProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    private boolean keepHeldItem = false;

    public DeployerApplicationRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.DEPLOYING, params);
    }

    public boolean matches(RecipeWrapper inv, World p_77569_2_) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.func_70301_a(0)) && ((Ingredient)this.ingredients.get(1)).test(inv.func_70301_a(1));
    }

    @Override
    protected int getMaxInputCount() {
        return 2;
    }

    @Override
    protected int getMaxOutputCount() {
        return 2;
    }

    public boolean shouldKeepHeldItem() {
        return this.keepHeldItem;
    }

    public Ingredient getRequiredHeldItem() {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("Deploying Recipe: " + this.id.toString() + " has no tool!");
        }
        return (Ingredient)this.ingredients.get(1);
    }

    public Ingredient getProcessedItem() {
        if (this.ingredients.size() < 2) {
            throw new IllegalStateException("Deploying Recipe: " + this.id.toString() + " has no ingredient!");
        }
        return (Ingredient)this.ingredients.get(0);
    }

    public static List<DeployerApplicationRecipe> convert(List<IRecipe<?>> sandpaperRecipes) {
        return sandpaperRecipes.stream().map(r -> new ProcessingRecipeBuilder<DeployerApplicationRecipe>(DeployerApplicationRecipe::new, new ResourceLocation(r.func_199560_c().func_110624_b(), r.func_199560_c().func_110623_a() + "_using_deployer")).require((Ingredient)r.func_192400_c().get(0)).require(AllTags.AllItemTags.SANDPAPER.tag).output(r.func_77571_b()).build()).collect(Collectors.toList());
    }

    @Override
    public void addAssemblyIngredients(List<Ingredient> list) {
        list.add((Ingredient)this.ingredients.get(1));
    }

    @Override
    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.keepHeldItem = JSONUtils.func_151209_a((JsonObject)json, (String)"keepHeldItem", (boolean)false);
    }

    @Override
    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        if (this.keepHeldItem) {
            json.addProperty("keepHeldItem", Boolean.valueOf(this.keepHeldItem));
        }
    }

    @Override
    public void readAdditional(PacketBuffer buffer) {
        super.readAdditional(buffer);
        this.keepHeldItem = buffer.readBoolean();
    }

    @Override
    public void writeAdditional(PacketBuffer buffer) {
        super.writeAdditional(buffer);
        buffer.writeBoolean(this.keepHeldItem);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ITextComponent getDescriptionForAssembly() {
        ItemStack[] matchingStacks = ((Ingredient)this.ingredients.get(1)).func_193365_a();
        if (matchingStacks.length == 0) {
            return new StringTextComponent("Invalid");
        }
        return Lang.translate("recipe.assembly.deploying_item", new TranslationTextComponent(matchingStacks[0].func_77977_a()).getString());
    }

    @Override
    public void addRequiredMachines(Set<IItemProvider> list) {
        list.add((IItemProvider)AllBlocks.DEPLOYER.get());
    }

    @Override
    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> SequencedAssemblySubCategory.AssemblyDeploying::new;
    }
}

