/*
 * Decompiled with CFR 0.152.
 */
package chylex.customwindowtitle;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class TitleConfig {
    private static final Map<String, String> DEFAULTS;
    private final String title;
    private final Path icon16;
    private final Path icon32;

    public static TitleConfig read(String folder) {
        Path configFile = Paths.get(folder, "customwindowtitle-client.toml");
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>(DEFAULTS);
        try {
            if (!Files.exists(configFile, new LinkOption[0])) {
                Files.write(configFile, (Iterable<? extends CharSequence>)config.entrySet().stream().map(entry -> String.format("%s = '%s'", entry.getKey(), entry.getValue())).collect(Collectors.toList()), StandardCharsets.UTF_8, new OpenOption[0]);
            } else {
                Files.readAllLines(configFile, StandardCharsets.UTF_8).stream().map(String::trim).filter(line -> !line.isEmpty()).forEach(line -> {
                    String[] split = line.split("=", 2);
                    if (split.length != 2) {
                        throw new RuntimeException("CustomWindowTitle configuration has an invalid line: " + line);
                    }
                    String key = split[0].trim();
                    String value = TitleConfig.parseTrimmedValue(split[1].trim());
                    if (!config.containsKey(key)) {
                        throw new RuntimeException("CustomWindowTitle configuration has an invalid key: " + key);
                    }
                    config.put(key, value);
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("CustomWindowTitle configuration error", e);
        }
        String icon16 = (String)config.get("icon16");
        String icon32 = (String)config.get("icon32");
        Path pathIcon16 = icon16.isEmpty() ? null : Paths.get(folder, icon16);
        Path pathIcon32 = icon32.isEmpty() ? null : Paths.get(folder, icon32);
        if (pathIcon16 == null != (pathIcon32 == null)) {
            throw new RuntimeException("CustomWindowTitle configuration specifies only one icon, both 'icon16' and 'icon32' must be set.");
        }
        if (pathIcon16 != null && Files.notExists(pathIcon16, new LinkOption[0])) {
            throw new RuntimeException("CustomWindowTitle 16x16 icon not found: " + pathIcon16);
        }
        if (pathIcon32 != null && Files.notExists(pathIcon32, new LinkOption[0])) {
            throw new RuntimeException("CustomWindowTitle 32x32 icon not found: " + pathIcon32);
        }
        return new TitleConfig((String)config.get("title"), pathIcon16, pathIcon32);
    }

    private static String parseTrimmedValue(String value) {
        if (value.isEmpty()) {
            return value;
        }
        char surrounding = value.charAt(0);
        int length = value.length();
        if (value.charAt(length - 1) == surrounding) {
            value = value.substring(1, length - 1);
            if (surrounding == '\"') {
                value = value.replace("\\\"", "\"").replace("\\\\", "\\");
            }
        }
        return value;
    }

    private TitleConfig(String title, Path icon16, Path icon32) {
        this.title = title;
        this.icon16 = icon16;
        this.icon32 = icon32;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasIcon() {
        return this.icon16 != null && this.icon32 != null;
    }

    public InputStream readIcon16() {
        try {
            return Files.newInputStream(this.icon16, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException("CustomWindowTitle could not open the specified 16x16 icon: " + this.icon16, e);
        }
    }

    public InputStream readIcon32() {
        try {
            return Files.newInputStream(this.icon32, StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new RuntimeException("CustomWindowTitle could not open the specified 32x32 icon: " + this.icon16, e);
        }
    }

    static {
        LinkedHashMap<String, String> defaults = new LinkedHashMap<String, String>();
        defaults.put("title", "Minecraft {mcversion}");
        defaults.put("icon16", "");
        defaults.put("icon32", "");
        DEFAULTS = Collections.unmodifiableMap(defaults);
    }
}

