/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.compat.ccl;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.annotation.Nonnull;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.util.ModelQuadUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class SinkingVertexBuilder
implements IVertexBuilder {
    private static final int VERTEX_SIZE_BYTES = 32;
    private static final int INITIAL_CAPACITY = 16384;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private ByteBuffer buffer = EMPTY_BUFFER;
    private final int[] sideCount = new int[ModelQuadFacing.VALUES.length];
    private int currentVertex;
    private float x;
    private float y;
    private float z;
    private float u;
    private float v;
    private int color;
    private int light;
    private final ModelQuadView previousQuad = new ModelQuadView(){

        private int getBaseIndex(int idx, int offset) {
            return (SinkingVertexBuilder.this.currentVertex - 4 + idx) * 32 + offset * 4;
        }

        @Override
        public float getX(int idx) {
            return SinkingVertexBuilder.this.buffer.getFloat(this.getBaseIndex(idx, 1));
        }

        @Override
        public float getY(int idx) {
            return SinkingVertexBuilder.this.buffer.getFloat(this.getBaseIndex(idx, 2));
        }

        @Override
        public float getZ(int idx) {
            return SinkingVertexBuilder.this.buffer.getFloat(this.getBaseIndex(idx, 3));
        }

        @Override
        public int getColor(int idx) {
            return SinkingVertexBuilder.this.buffer.getInt(this.getBaseIndex(idx, 4));
        }

        @Override
        public float getTexU(int idx) {
            return SinkingVertexBuilder.this.buffer.getFloat(this.getBaseIndex(idx, 5));
        }

        @Override
        public float getTexV(int idx) {
            return SinkingVertexBuilder.this.buffer.getFloat(this.getBaseIndex(idx, 6));
        }

        @Override
        public int getLight(int idx) {
            return SinkingVertexBuilder.this.buffer.getInt(this.getBaseIndex(idx, 7));
        }

        @Override
        public int getNormal(int idx) {
            return 0;
        }

        @Override
        public int getFlags() {
            return 0;
        }

        @Override
        public int getColorIndex() {
            return 0;
        }

        @Override
        public TextureAtlasSprite rubidium$getSprite() {
            return null;
        }
    };

    private static ByteBuffer reallocDirect(ByteBuffer old, int capacity) {
        ByteBuffer newBuf = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        int oldPos = old.position();
        old.rewind();
        newBuf.put(old);
        newBuf.position(Math.min(capacity, oldPos));
        old.position(oldPos);
        return newBuf;
    }

    @Nonnull
    public IVertexBuilder func_225582_a_(double x, double y, double z) {
        this.x = (float)x;
        this.y = (float)y;
        this.z = (float)z;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225586_a_(int r, int g, int b, int a) {
        this.color = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225583_a_(float u, float v) {
        this.u = u;
        this.v = v;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225585_a_(int u, int v) {
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225587_b_(int u, int v) {
        this.light = v << 16 | u;
        return this;
    }

    @Nonnull
    public IVertexBuilder func_225584_a_(float x, float y, float z) {
        return this;
    }

    public void func_181675_d() {
        if (this.buffer.capacity() - this.buffer.position() < 32) {
            int newCapacity = this.buffer.capacity() * 2;
            if (newCapacity == 0) {
                newCapacity = 16384;
            }
            this.buffer = SinkingVertexBuilder.reallocDirect(this.buffer, newCapacity);
        }
        ByteBuffer buffer = this.buffer;
        buffer.putInt(-1);
        buffer.putFloat(this.x);
        buffer.putFloat(this.y);
        buffer.putFloat(this.z);
        buffer.putFloat(this.u);
        buffer.putFloat(this.v);
        buffer.putInt(this.color);
        buffer.putInt(this.light);
        this.resetCurrentVertex();
        ++this.currentVertex;
        if (this.currentVertex % 4 == 0) {
            this.recalculateNormals();
        }
    }

    private void recalculateNormals() {
        ModelQuadFacing normal = ModelQuadUtil.findNormalFace(ModelQuadUtil.calculateNormal(this.previousQuad));
        this.buffer.putInt((this.currentVertex - 4) * 32, normal.ordinal());
    }

    public void reset() {
        this.buffer.rewind();
        this.currentVertex = 0;
        Arrays.fill(this.sideCount, 0);
        this.resetCurrentVertex();
    }

    public boolean flush(@Nonnull ChunkModelBuffers buffers) {
        if (this.currentVertex == 0) {
            return false;
        }
        int numQuads = this.currentVertex >> 2;
        for (int quadIdx = 0; quadIdx < numQuads; ++quadIdx) {
            int normal;
            int n = normal = this.buffer.getInt(quadIdx << 2 << 5);
            this.sideCount[n] = this.sideCount[n] + 1;
        }
        for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
            int count = this.sideCount[facing.ordinal()];
            if (count == 0) continue;
            buffers.getSink(facing).ensureCapacity(count << 2);
        }
        int byteSize = this.currentVertex << 5;
        int sideMask = 0;
        this.buffer.rewind();
        while (this.buffer.position() < byteSize) {
            ModelQuadFacing facing;
            int normal = this.buffer.getInt();
            facing = ModelQuadFacing.VALUES[normal];
            int facingIdx = facing.ordinal();
            ModelVertexSink sink = buffers.getSink(facing);
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            this.buffer.getInt();
            this.writeQuadVertex(sink);
            sideMask = (byte)(sideMask | 1 << facingIdx);
        }
        for (ModelQuadFacing facing : ModelQuadFacing.VALUES) {
            if ((sideMask >> facing.ordinal() & 1) == 0) continue;
            buffers.getSink(facing).flush();
        }
        return true;
    }

    private void writeQuadVertex(@Nonnull ModelVertexSink sink) {
        float x = this.buffer.getFloat();
        float y = this.buffer.getFloat();
        float z = this.buffer.getFloat();
        float u = this.buffer.getFloat();
        float v = this.buffer.getFloat();
        int color = this.buffer.getInt();
        int light = this.buffer.getInt();
        sink.writeQuad(x, y, z, color, u, v, light);
    }

    private void resetCurrentVertex() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.v = 0.0f;
        this.u = 0.0f;
        this.color = -1;
        this.light = 0;
    }
}

