/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.model.light.data;

import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;

public abstract class LightDataAccess {
    private final BlockPos.Mutable pos = new BlockPos.Mutable();
    protected IBlockDisplayReader world;

    public long get(int x, int y, int z, Direction d1, Direction d2) {
        return this.get(x + d1.func_82601_c() + d2.func_82601_c(), y + d1.func_96559_d() + d2.func_96559_d(), z + d1.func_82599_e() + d2.func_82599_e());
    }

    public long get(int x, int y, int z, Direction dir) {
        return this.get(x + dir.func_82601_c(), y + dir.func_96559_d(), z + dir.func_82599_e());
    }

    public long get(BlockPos pos, Direction dir) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dir);
    }

    public long get(BlockPos pos) {
        return this.get(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public abstract long get(int var1, int var2, int var3);

    protected long compute(int x, int y, int z) {
        boolean em;
        float ao;
        IBlockDisplayReader world = this.world;
        BlockPos.Mutable pos = this.pos.func_181079_c(x, y, z);
        BlockState state = world.func_180495_p((BlockPos)pos);
        if (state.getLightValue((IBlockReader)world, (BlockPos)pos) == 0) {
            ao = state.func_215703_d((IBlockReader)world, (BlockPos)pos);
            em = state.func_227035_k_((IBlockReader)world, (BlockPos)pos);
        } else {
            ao = 1.0f;
            em = true;
        }
        boolean op = !state.func_215696_m((IBlockReader)world, (BlockPos)pos) || state.func_200016_a((IBlockReader)world, (BlockPos)pos) == 0;
        boolean fo = state.func_200015_d((IBlockReader)world, (BlockPos)pos);
        boolean fc = state.func_235785_r_((IBlockReader)world, (BlockPos)pos);
        int lm = fo && !em ? 0 : WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos);
        return LightDataAccess.packAO(ao) | LightDataAccess.packLM(lm) | LightDataAccess.packOP(op) | LightDataAccess.packFO(fo) | LightDataAccess.packFC(fc) | 0x1000000000000000L;
    }

    public static long packOP(boolean opaque) {
        return (opaque ? 1L : 0L) << 56;
    }

    public static boolean unpackOP(long word) {
        return (word >>> 56 & 1L) != 0L;
    }

    public static long packFO(boolean opaque) {
        return (opaque ? 1L : 0L) << 57;
    }

    public static boolean unpackFO(long word) {
        return (word >>> 57 & 1L) != 0L;
    }

    public static long packFC(boolean fullCube) {
        return (fullCube ? 1L : 0L) << 58;
    }

    public static boolean unpackFC(long word) {
        return (word >>> 58 & 1L) != 0L;
    }

    public static long packLM(int lm) {
        return (long)lm & 0xFFFFFFFFL;
    }

    public static int unpackLM(long word) {
        return (int)(word & 0xFFFFFFFFL);
    }

    public static long packAO(float ao) {
        int aoi = (int)(ao * 4096.0f);
        return ((long)aoi & 0xFFFFL) << 32;
    }

    public static float unpackAO(long word) {
        int aoi = (int)(word >>> 32 & 0xFFFFL);
        return (float)aoi * 2.4414062E-4f;
    }

    public IBlockDisplayReader getWorld() {
        return this.world;
    }
}

